<?php
$backgroundImage = get_sub_field('background_image');
$backgroundImage = wp_get_attachment_image_url($backgroundImage, 'banner');
$tartanColour = strtolower(get_sub_field('tartan_colour')) . '-tartan';

$title = get_sub_field('title');
$content = get_sub_field('content');
$link = get_sub_field('link');

$featuredImage = get_sub_field('featured_image');
$featuredImage = wp_get_attachment_image_url($featuredImage, 'full');

?>
<section class="offset-section container" style="background-image:url('<?= $backgroundImage; ?>')">
    <div class="offset-feature wrap-large" style="background-image:url('<?= $featuredImage; ?>')">
        <div class="featured-image d-md-none">
            <img src="<?= $featuredImage; ?>" alt=""/>
        </div> 
        <?php if($title || $content) { ?>
            <div class="content-wrap <?= $tartanColour; ?>">
                <h1><?= $title; ?></h1>
                <p><?= $content; ?></p>
                <?php if($link) { ?><a class="btn btn-primary" href="<?= $link['url']; ?>" target="<?= $link['target']; ?>"><?= $link['title'] ?> <i class="far fa-arrow-right"></i></a><?php } ?>
            </div>
        <?php } ?>
    </div>
</section>
