<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
get_header('shop');
global $wp_query;

$title = get_the_title();
$description = get_the_content();
$image = get_the_post_thumbnail();
?>

<div class="product-page padding-wrap product-collection woocommerce">
    <section class="feature">
        <div class="feature__image">
            <?= $image ?>
        </div>
        <div class="feature__content">
            <h1><?= $title ?></h1>
            <?= $description ?>
        </div>
    </section>

    <?php get_template_part('woocommerce/parts/filter'); ?>

    <?php
    if (!isset($_GET) || empty($_GET)) {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
        );
        $categories = get_categories($args);
    } else {
        $validCollectionIds = \Blue2\Scruffy\Controllers\WooCommerceController::getFilteredCollections();
        if ($validCollectionIds !== false) {
            $categories = get_terms(['taxonomy' => 'product_cat', 'term_taxonomy_id' => $validCollectionIds]);
        } else $categories = [];
    }

    if (!empty($categories)) { ?>
        <section class="intro intro--front-page container text-center">
            <div class="intro__content col-12" data-aos="zoom-out" data-aos-anchor-placement="top-bottom">
                <h2>All Collections</h2>
            </div>
        </section>
        <section class="product-list">
            <div class="row ">
                <?php \Blue2\Scruffy\Controllers\WooCommerceController::outputCollections($categories); ?>
            </div>
        </section>
    <?php } else {
        /**
         * woocommerce_no_products_found hook.
         *
         * @hooked wc_no_products_found - 10
         */
        do_action('woocommerce_no_products_found');
    } ?>
</div>
<?php \Blue2\Scruffy\Utils::flexibleLoop('page_blocks'); ?>
<?php get_footer('shop'); ?>

