import loadScript from './utils/externalScriptLoader';
import { GOOGLE_API_KEY } from './constants';
import markerImage from '../images/map-pin-location.svg';
import MarkerClusterer from '@google/markerclusterer';

let center;
let markerIcon;
const markers = [...document.querySelectorAll('.marker')];
const searchInput = document.getElementById('map-search');
const clusterMarkers = [];
let map;

const addMarkers = function() {
    const bounds = new google.maps.LatLngBounds();
    for (const [index, marker] of markers.entries()) {
        const latlng = new google.maps.LatLng(
            parseFloat(marker.dataset.lat),
            parseFloat(marker.dataset.lng)
        );

        if (index === 0) {
            center = latlng;
        }
        const newMarker = new google.maps.Marker({
            position: latlng,
            icon: markerIcon
        });

        const id = marker.dataset.index;
        if (typeof (id) !== 'undefined') {
            newMarker.addListener('click', () => {
                const scroller = document.getElementById('scroller');
                const anchor = $(`#${id}`);
                const position = anchor.position().top + scroller.scrollTop;

                anchor.parent().addClass('fade-articles');
                anchor.addClass('active');

                $('.scroll-container').animate({ scrollTop: position });
                if (marker.innerHTML) {
                    const infowindow = new google.maps.InfoWindow({
                        content: marker.innerHTML
                    });
                    infowindow.open(map, newMarker);
                }
            });
        }

        bounds.extend(latlng);
        clusterMarkers.push(newMarker);
    }

    if (clusterMarkers.length !== 1) {
        map.fitBounds(bounds);
    }
    map.setCenter(center);
};

function createSearchBox() {
// Create Google Places SearchBox from Dom input
    const searchBox = new google.maps.places.SearchBox(searchInput);
    searchBox.addListener('places_changed', () => {
        const places = searchBox.getPlaces();
        const bounds = new google.maps.LatLngBounds();
        if (places.length === 0) {
            return;
        }
        places.forEach(place => {
            if (!place.geometry) {
                return;
            }
            if (place.geometry.viewport) {
                bounds.union(place.geometry.viewport);
            } else {
                bounds.extend(place.geometry.location);
            }
        });

        map.fitBounds(bounds);
    });
}

function initMap() {
    // Create google map
    map = new google.maps.Map(document.getElementById('google-map'), {
        zoom: 8,
        disableDefaultUI: true
    });

    markerIcon = {
        url: markerImage,
        size: new google.maps.Size(48, 58),
        origin: new google.maps.Point(0, 0),
        anchor: new google.maps.Point(15, 40)
    };
    // Add all markers
    addMarkers();
    // Create clusters from markers
    new MarkerClusterer(map, clusterMarkers, {
        styles: [{
            url: '/content/themes/isle-mill-theme/dist/images/map-pin-sum.svg',
            height: 58,
            width: 48,
            textColor: '#ffffff',
            textSize: 14,
            anchor: [12, 0]
        }]
    });

    if (searchInput !== null) {
        createSearchBox();
    }
}


loadScript(`https://maps.googleapis.com/maps/api/js?key=${GOOGLE_API_KEY}&libraries=places`).then(() => {
    initMap();
});

