// import 'aos/dist/aos.css';
import Swiper from 'swiper';

const scrollToTarget = function(tgtEl, siteHeader, scrollSpeed = 500) {
    if (typeof tgtEl !== 'undefined') {
        // is header fixed?
        let hoffset = 0;
        if (typeof siteHeader !== 'undefined') {
            if (siteHeader.css('position') === 'fixed') {
                hoffset = siteHeader.height();
            }
        }
        if (tgtEl.parent().css('display') !== 'none') {
            const scrollToHere = tgtEl.offset().top - hoffset;
            $('html, body').animate({
                scrollTop: scrollToHere,
            }, scrollSpeed);
        }
    }
};

const scrollToTargetIni = function() {
    $('a.scrollToTgt[href^="#"]').on('click', function(e) {
        e.preventDefault();
        let tgtEl = '';
        if ($(this).attr('href').length > 1) {
            if ($(this).attr('href') === '#top') {
                tgtEl = $('body');
            } else {
                tgtEl = $($(this).attr('href'));
            }
            const scrollSpeed = 500;
            const siteHeader = $('header.site-header');

            scrollToTarget(tgtEl, siteHeader, scrollSpeed);
        }
    });
};

const common = () => {
    scrollToTargetIni();
    // button[data-target="#navbarSupportedContent"]
    $('.header-nav .navbar-toggler').on('click', e => {
        e.preventDefault();
        $('body').toggleClass('pushNavOpen');
    });

    $('a[href="#toggle-mobile-search"]').on('click', e => {
        e.preventDefault();
        const mobileSearch = $('#mobile-search');
        mobileSearch.toggleClass('mobile-search--on');

        if (mobileSearch.hasClass('mobile-search--on')) {
            $('#mobile-search .search-field').focus();
        }
    });

    $('.searchform--header .search-field').on('focus', () => {
        $('.searchform--header').addClass('on');
    });
    $('.searchform--header .search-form__close').on('click', e => {
        e.preventDefault();
        $('.searchform--header').removeClass('on');
    });
    $('.searchform--header .search-field').on('blur', () => {
        $('.searchform--header').removeClass('on');
    });

    if ($('.banner__swiper')) {
        const bannerSwiper = new Swiper('.banner__swiper', {
            loop: true,
            speed: 2000,
            autoplay: {
                delay: 5000,
            },
            loopAdditionalSlides: 2,
            keyboard: {
                enabled: true,
            }
        });
        bannerSwiper.on('slideChange', function() {
            const activeSlide = bannerSwiper.activeIndex;
            const tartan = $('.banner__swiper>ul>li').eq(activeSlide)
                .attr('data-tartan');
            $('.banner__content').removeClass('banner__content--tartan-Red banner__content--tartan-Green banner__content--tartan-Blue')
                .addClass(`banner__content--tartan-${tartan}`);
        });
    }
};

$(document).ready(function() {
    $('.heading-column').on('click', function(event) {
        if (this.hash !== '') {
            event.preventDefault();
            const hash = this.hash;
            $('html, body').animate({
                scrollTop: $(hash).offset().top
            }, 800, function() {
                window.location.hash = hash;
            });
        }
    });
});

$(window).on('resize load', () => {
    setTimeout(
        () => {
            if ($(window).width() < 768) {
                $('#google_translate_element--desktop #google_translate_element').appendTo('#google_translate_element--mobile');
            } else {
                $('#google_translate_element--mobile #google_translate_element').appendTo('#google_translate_element--desktop');
            }
        }
        , 1000);
});


$(document).ready(function() {
    const modalSuccess = $('#modalSuccess');
    if (modalSuccess) {
        console.log('here');
        modalSuccess.modal('show');
    }
});

export default common;
