<?php

use Blue2\Scruffy\Controllers\ClanTartanController;

if (isset($_GET['letter'])) {
    $activeLetter = $_GET['letter'];
} else {
    $activeLetter = 'A';
}
if (have_rows('page_blocks')) {
    while (have_rows('page_blocks')) {
        the_row();
        $backgroundImage = get_sub_field('background_image');
        $backgroundImage = wp_get_attachment_image_url($backgroundImage, 'banner');

        $title = get_sub_field('title');
        $content = get_sub_field('content');
        $link = get_sub_field('link');

        $featuredImage = get_sub_field('featured_image');
        $featuredImage = wp_get_attachment_image_url($featuredImage, 'banner');
        ?>
        <section class="offset-section offset-section__build-outfit"
                 style="background-image:url('<?= $backgroundImage; ?>')">
            <div class="offset-feature wrap-large" style="background-image:url('<?= $featuredImage; ?>')">
                <div class="content-wrap">
                    <span class="supertitle">Our Products</span>
                    <h1><?= $title; ?></h1>
                    <p><?= $content; ?></p>
                    <?php if ($link) { ?>
                        <a class="btn btn-primary" href="<?= $link['url']; ?>"
                           target="<?= $link['target']; ?>"><?= $link['title'] ?></a>
                    <?php } ?>
                </div>
            </div>
        </section>
    <?php }
} ?>

<section class="wrap-large container tartan-finder">
    <form class="row tartan-form" method="POST">
        <div class="col-md-6 center-search">
            <input class="tartan-finder" name="familyName" placeholder="Type your clan name">
            <button class="form-submit" type="submit"><i class="fal fa-search"></i></button>
        </div>
    </form>
    <div class="row">
        <div class="col-md-12 text-center"><strong>Or browse tartans by A-Z</strong></div>
        <div class="col-md-12 letter-picker">
            <?php
            for ($x = "A"; ; $x++) { ?>
                <a <?= $activeLetter == $x ? 'class="active"' : ''; ?> href="?letter=<?= $x; ?>"><?= $x; ?></a>
                <?php if ($x == "Z") break;
            }
            ?>
        </div>
    </div>
</section>

<section class="wrap-large tartan-finder product-list">
    <div class="row ">
        <?php ClanTartanController::getClanTartansByFirstLetter($activeLetter); ?>
    </div>
</section>