<?php

namespace Blue2\Scruffy;

class Utils extends \Blue2\Common\Theme\Utils
{
    public static function simpleWrappedLoop($contentSlug = "", $headerName = "", $footerName = "")
    {
        get_header($headerName);
        self::simpleLoop($contentSlug);
        get_footer($footerName);
    }

    public static function simpleLoop($contentSlug = "")
    {
        if (have_posts()) {
            while (have_posts()) {
                the_post();
                if (is_single() && $contentSlug === "") {
                    parent::includeContentTemplate($contentSlug);
                } else if (is_cart() || is_checkout() || is_account_page()) {
                    get_template_part('templates/content-woocommerce');
                } else {
                    parent::includeContentTemplate($contentSlug);
                }

            }
        } else {
            get_template_part('templates/content', 'none');
        }
    }

    public static function archiveWrapped($headerName = "", $footerName = "")
    {
        if (!get_post_type()) {
            global $wp_query;
            $postType = $wp_query->query['post_type'];
        } else {
            $postType = get_post_type();
        }

        $template = ($postType == 'stockist' || $postType == 'distributor') ? 'distributor-stockist' : $postType;

        get_header($headerName);
        locate_template('templates/' . $template . '/archive.php', true);
        get_footer($footerName);
    }

    public static function searchLoop($foundCollections = 0)
    {
        if (have_posts()) {
            while (have_posts()) {
                the_post();
                get_template_part('templates/content', 'search');
            }
        } else {
            if (!$foundCollections) {
                echo "<h2 class='text-center'>Sorry, no results were found</h2>";
            }
        }
    }

    public static function collectionSearch()
    {
        $searchTerm = trim(str_ireplace("collection", "", get_search_query()));

        $args = [
            'taxonomy' => ['product_cat'], // taxonomy name
            'orderby' => 'id',
            'order' => 'ASC',
            'hide_empty' => true,
            'fields' => 'all',
            'name__like' => $searchTerm,
        ];
        return get_terms($args);
    }
}
