(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["vendors~maps"],{

/***/ "./node_modules/@google/markerclusterer/src/markerclusterer.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@google/markerclusterer/src/markerclusterer.js ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// ==ClosureCompiler==
// @compilation_level ADVANCED_OPTIMIZATIONS
// @externs_url http://closure-compiler.googlecode.com/svn/trunk/contrib/externs/maps/google_maps_api_v3_3.js
// ==/ClosureCompiler==

/**
 * @name MarkerClusterer for Google Maps v3
 * @version version 1.0.3
 * @author Luke Mahe
 * @fileoverview
 * The library creates and manages per-zoom-level clusters for large amounts of
 * markers.
 */

/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * A Marker Clusterer that clusters markers.
 *
 * @param {google.maps.Map} map The Google map to attach to.
 * @param {Array.<google.maps.Marker>=} opt_markers Optional markers to add to
 *   the cluster.
 * @param {Object=} opt_options support the following options:
 *     'gridSize': (number) The grid size of a cluster in pixels.
 *     'maxZoom': (number) The maximum zoom level that a marker can be part of a
 *                cluster.
 *     'zoomOnClick': (boolean) Whether the default behaviour of clicking on a
 *                    cluster is to zoom into it.
 *     'imagePath': (string) The base URL where the images representing
 *                  clusters will be found. The full URL will be:
 *                  {imagePath}[1-5].{imageExtension}
 *                  Default: '../images/m'.
 *     'imageExtension': (string) The suffix for images URL representing
 *                       clusters will be found. See _imagePath_ for details.
 *                       Default: 'png'.
 *     'averageCenter': (boolean) Whether the center of each cluster should be
 *                      the average of all markers in the cluster.
 *     'minimumClusterSize': (number) The minimum number of markers to be in a
 *                           cluster before the markers are hidden and a count
 *                           is shown.
 *     'styles': (object) An object that has style properties:
 *       'url': (string) The image url.
 *       'height': (number) The image height.
 *       'width': (number) The image width.
 *       'anchor': (Array) The anchor position of the label text.
 *       'textColor': (string) The text color.
 *       'textSize': (number) The text size.
 *       'backgroundPosition': (string) The position of the backgound x, y.
 * @constructor
 * @extends google.maps.OverlayView
 */
function MarkerClusterer(map, opt_markers, opt_options) {
  // MarkerClusterer implements google.maps.OverlayView interface. We use the
  // extend function to extend MarkerClusterer with google.maps.OverlayView
  // because it might not always be available when the code is defined so we
  // look for it at the last possible moment. If it doesn't exist now then
  // there is no point going ahead :)
  this.extend(MarkerClusterer, google.maps.OverlayView);
  this.map_ = map;
  /**
   * @type {Array.<google.maps.Marker>}
   * @private
   */

  this.markers_ = [];
  /**
   *  @type {Array.<Cluster>}
   */

  this.clusters_ = [];
  this.sizes = [53, 56, 66, 78, 90];
  /**
   * @private
   */

  this.styles_ = [];
  /**
   * @type {boolean}
   * @private
   */

  this.ready_ = false;
  var options = opt_options || {};
  /**
   * @type {number}
   * @private
   */

  this.gridSize_ = options['gridSize'] || 60;
  /**
   * @private
   */

  this.minClusterSize_ = options['minimumClusterSize'] || 2;
  /**
   * @type {?number}
   * @private
   */

  this.maxZoom_ = options['maxZoom'] || null;
  this.styles_ = options['styles'] || [];
  /**
   * @type {string}
   * @private
   */

  this.imagePath_ = options['imagePath'] || this.MARKER_CLUSTER_IMAGE_PATH_;
  /**
   * @type {string}
   * @private
   */

  this.imageExtension_ = options['imageExtension'] || this.MARKER_CLUSTER_IMAGE_EXTENSION_;
  /**
   * @type {boolean}
   * @private
   */

  this.zoomOnClick_ = true;

  if (options['zoomOnClick'] != undefined) {
    this.zoomOnClick_ = options['zoomOnClick'];
  }
  /**
   * @type {boolean}
   * @private
   */


  this.averageCenter_ = false;

  if (options['averageCenter'] != undefined) {
    this.averageCenter_ = options['averageCenter'];
  }

  this.setupStyles_();
  this.setMap(map);
  /**
   * @type {number}
   * @private
   */

  this.prevZoom_ = this.map_.getZoom(); // Add the map event listeners

  var that = this;
  google.maps.event.addListener(this.map_, 'zoom_changed', function () {
    // Determines map type and prevent illegal zoom levels
    var zoom = that.map_.getZoom();
    var minZoom = that.map_.minZoom || 0;
    var maxZoom = Math.min(that.map_.maxZoom || 100, that.map_.mapTypes[that.map_.getMapTypeId()].maxZoom);
    zoom = Math.min(Math.max(zoom, minZoom), maxZoom);

    if (that.prevZoom_ != zoom) {
      that.prevZoom_ = zoom;
      that.resetViewport();
    }
  });
  google.maps.event.addListener(this.map_, 'idle', function () {
    that.redraw();
  }); // Finally, add the markers

  if (opt_markers && (opt_markers.length || Object.keys(opt_markers).length)) {
    this.addMarkers(opt_markers, false);
  }
}
/**
 * The marker cluster image path.
 *
 * @type {string}
 * @private
 */


MarkerClusterer.prototype.MARKER_CLUSTER_IMAGE_PATH_ = '../images/m';
/**
 * The marker cluster image path.
 *
 * @type {string}
 * @private
 */

MarkerClusterer.prototype.MARKER_CLUSTER_IMAGE_EXTENSION_ = 'png';
/**
 * Extends a objects prototype by anothers.
 *
 * @param {Object} obj1 The object to be extended.
 * @param {Object} obj2 The object to extend with.
 * @return {Object} The new extended object.
 * @ignore
 */

MarkerClusterer.prototype.extend = function (obj1, obj2) {
  return function (object) {
    for (var property in object.prototype) {
      this.prototype[property] = object.prototype[property];
    }

    return this;
  }.apply(obj1, [obj2]);
};
/**
 * Implementaion of the interface method.
 * @ignore
 */


MarkerClusterer.prototype.onAdd = function () {
  this.setReady_(true);
};
/**
 * Implementaion of the interface method.
 * @ignore
 */


MarkerClusterer.prototype.draw = function () {};
/**
 * Sets up the styles object.
 *
 * @private
 */


MarkerClusterer.prototype.setupStyles_ = function () {
  if (this.styles_.length) {
    return;
  }

  for (var i = 0, size; size = this.sizes[i]; i++) {
    this.styles_.push({
      url: this.imagePath_ + (i + 1) + '.' + this.imageExtension_,
      height: size,
      width: size
    });
  }
};
/**
 *  Fit the map to the bounds of the markers in the clusterer.
 */


MarkerClusterer.prototype.fitMapToMarkers = function () {
  var markers = this.getMarkers();
  var bounds = new google.maps.LatLngBounds();

  for (var i = 0, marker; marker = markers[i]; i++) {
    bounds.extend(marker.getPosition());
  }

  this.map_.fitBounds(bounds);
};
/**
 *  Sets the styles.
 *
 *  @param {Object} styles The style to set.
 */


MarkerClusterer.prototype.setStyles = function (styles) {
  this.styles_ = styles;
};
/**
 *  Gets the styles.
 *
 *  @return {Object} The styles object.
 */


MarkerClusterer.prototype.getStyles = function () {
  return this.styles_;
};
/**
 * Whether zoom on click is set.
 *
 * @return {boolean} True if zoomOnClick_ is set.
 */


MarkerClusterer.prototype.isZoomOnClick = function () {
  return this.zoomOnClick_;
};
/**
 * Whether average center is set.
 *
 * @return {boolean} True if averageCenter_ is set.
 */


MarkerClusterer.prototype.isAverageCenter = function () {
  return this.averageCenter_;
};
/**
 *  Returns the array of markers in the clusterer.
 *
 *  @return {Array.<google.maps.Marker>} The markers.
 */


MarkerClusterer.prototype.getMarkers = function () {
  return this.markers_;
};
/**
 *  Returns the number of markers in the clusterer
 *
 *  @return {Number} The number of markers.
 */


MarkerClusterer.prototype.getTotalMarkers = function () {
  return this.markers_.length;
};
/**
 *  Sets the max zoom for the clusterer.
 *
 *  @param {number} maxZoom The max zoom level.
 */


MarkerClusterer.prototype.setMaxZoom = function (maxZoom) {
  this.maxZoom_ = maxZoom;
};
/**
 *  Gets the max zoom for the clusterer.
 *
 *  @return {number} The max zoom level.
 */


MarkerClusterer.prototype.getMaxZoom = function () {
  return this.maxZoom_;
};
/**
 *  The function for calculating the cluster icon image.
 *
 *  @param {Array.<google.maps.Marker>} markers The markers in the clusterer.
 *  @param {number} numStyles The number of styles available.
 *  @return {Object} A object properties: 'text' (string) and 'index' (number).
 *  @private
 */


MarkerClusterer.prototype.calculator_ = function (markers, numStyles) {
  var index = 0;
  var count = markers.length;
  var dv = count;

  while (dv !== 0) {
    dv = parseInt(dv / 10, 10);
    index++;
  }

  index = Math.min(index, numStyles);
  return {
    text: count,
    index: index
  };
};
/**
 * Set the calculator function.
 *
 * @param {function(Array, number)} calculator The function to set as the
 *     calculator. The function should return a object properties:
 *     'text' (string) and 'index' (number).
 *
 */


MarkerClusterer.prototype.setCalculator = function (calculator) {
  this.calculator_ = calculator;
};
/**
 * Get the calculator function.
 *
 * @return {function(Array, number)} the calculator function.
 */


MarkerClusterer.prototype.getCalculator = function () {
  return this.calculator_;
};
/**
 * Add an array of markers to the clusterer.
 *
 * @param {Array.<google.maps.Marker>} markers The markers to add.
 * @param {boolean=} opt_nodraw Whether to redraw the clusters.
 */


MarkerClusterer.prototype.addMarkers = function (markers, opt_nodraw) {
  if (markers.length) {
    for (var i = 0, marker; marker = markers[i]; i++) {
      this.pushMarkerTo_(marker);
    }
  } else if (Object.keys(markers).length) {
    for (var marker in markers) {
      this.pushMarkerTo_(markers[marker]);
    }
  }

  if (!opt_nodraw) {
    this.redraw();
  }
};
/**
 * Pushes a marker to the clusterer.
 *
 * @param {google.maps.Marker} marker The marker to add.
 * @private
 */


MarkerClusterer.prototype.pushMarkerTo_ = function (marker) {
  marker.isAdded = false;

  if (marker['draggable']) {
    // If the marker is draggable add a listener so we update the clusters on
    // the drag end.
    var that = this;
    google.maps.event.addListener(marker, 'dragend', function () {
      marker.isAdded = false;
      that.repaint();
    });
  }

  this.markers_.push(marker);
};
/**
 * Adds a marker to the clusterer and redraws if needed.
 *
 * @param {google.maps.Marker} marker The marker to add.
 * @param {boolean=} opt_nodraw Whether to redraw the clusters.
 */


MarkerClusterer.prototype.addMarker = function (marker, opt_nodraw) {
  this.pushMarkerTo_(marker);

  if (!opt_nodraw) {
    this.redraw();
  }
};
/**
 * Removes a marker and returns true if removed, false if not
 *
 * @param {google.maps.Marker} marker The marker to remove
 * @return {boolean} Whether the marker was removed or not
 * @private
 */


MarkerClusterer.prototype.removeMarker_ = function (marker) {
  var index = -1;

  if (this.markers_.indexOf) {
    index = this.markers_.indexOf(marker);
  } else {
    for (var i = 0, m; m = this.markers_[i]; i++) {
      if (m == marker) {
        index = i;
        break;
      }
    }
  }

  if (index == -1) {
    // Marker is not in our list of markers.
    return false;
  }

  marker.setMap(null);
  this.markers_.splice(index, 1);
  return true;
};
/**
 * Remove a marker from the cluster.
 *
 * @param {google.maps.Marker} marker The marker to remove.
 * @param {boolean=} opt_nodraw Optional boolean to force no redraw.
 * @return {boolean} True if the marker was removed.
 */


MarkerClusterer.prototype.removeMarker = function (marker, opt_nodraw) {
  var removed = this.removeMarker_(marker);

  if (!opt_nodraw && removed) {
    this.resetViewport();
    this.redraw();
    return true;
  } else {
    return false;
  }
};
/**
 * Removes an array of markers from the cluster.
 *
 * @param {Array.<google.maps.Marker>} markers The markers to remove.
 * @param {boolean=} opt_nodraw Optional boolean to force no redraw.
 */


MarkerClusterer.prototype.removeMarkers = function (markers, opt_nodraw) {
  // create a local copy of markers if required
  // (removeMarker_ modifies the getMarkers() array in place)
  var markersCopy = markers === this.getMarkers() ? markers.slice() : markers;
  var removed = false;

  for (var i = 0, marker; marker = markersCopy[i]; i++) {
    var r = this.removeMarker_(marker);
    removed = removed || r;
  }

  if (!opt_nodraw && removed) {
    this.resetViewport();
    this.redraw();
    return true;
  }
};
/**
 * Sets the clusterer's ready state.
 *
 * @param {boolean} ready The state.
 * @private
 */


MarkerClusterer.prototype.setReady_ = function (ready) {
  if (!this.ready_) {
    this.ready_ = ready;
    this.createClusters_();
  }
};
/**
 * Returns the number of clusters in the clusterer.
 *
 * @return {number} The number of clusters.
 */


MarkerClusterer.prototype.getTotalClusters = function () {
  return this.clusters_.length;
};
/**
 * Returns the google map that the clusterer is associated with.
 *
 * @return {google.maps.Map} The map.
 */


MarkerClusterer.prototype.getMap = function () {
  return this.map_;
};
/**
 * Sets the google map that the clusterer is associated with.
 *
 * @param {google.maps.Map} map The map.
 */


MarkerClusterer.prototype.setMap = function (map) {
  this.map_ = map;
};
/**
 * Returns the size of the grid.
 *
 * @return {number} The grid size.
 */


MarkerClusterer.prototype.getGridSize = function () {
  return this.gridSize_;
};
/**
 * Sets the size of the grid.
 *
 * @param {number} size The grid size.
 */


MarkerClusterer.prototype.setGridSize = function (size) {
  this.gridSize_ = size;
};
/**
 * Returns the min cluster size.
 *
 * @return {number} The grid size.
 */


MarkerClusterer.prototype.getMinClusterSize = function () {
  return this.minClusterSize_;
};
/**
 * Sets the min cluster size.
 *
 * @param {number} size The grid size.
 */


MarkerClusterer.prototype.setMinClusterSize = function (size) {
  this.minClusterSize_ = size;
};
/**
 * Extends a bounds object by the grid size.
 *
 * @param {google.maps.LatLngBounds} bounds The bounds to extend.
 * @return {google.maps.LatLngBounds} The extended bounds.
 */


MarkerClusterer.prototype.getExtendedBounds = function (bounds) {
  var projection = this.getProjection(); // Turn the bounds into latlng.

  var tr = new google.maps.LatLng(bounds.getNorthEast().lat(), bounds.getNorthEast().lng());
  var bl = new google.maps.LatLng(bounds.getSouthWest().lat(), bounds.getSouthWest().lng()); // Convert the points to pixels and the extend out by the grid size.

  var trPix = projection.fromLatLngToDivPixel(tr);
  trPix.x += this.gridSize_;
  trPix.y -= this.gridSize_;
  var blPix = projection.fromLatLngToDivPixel(bl);
  blPix.x -= this.gridSize_;
  blPix.y += this.gridSize_; // Convert the pixel points back to LatLng

  var ne = projection.fromDivPixelToLatLng(trPix);
  var sw = projection.fromDivPixelToLatLng(blPix); // Extend the bounds to contain the new bounds.

  bounds.extend(ne);
  bounds.extend(sw);
  return bounds;
};
/**
 * Determins if a marker is contained in a bounds.
 *
 * @param {google.maps.Marker} marker The marker to check.
 * @param {google.maps.LatLngBounds} bounds The bounds to check against.
 * @return {boolean} True if the marker is in the bounds.
 * @private
 */


MarkerClusterer.prototype.isMarkerInBounds_ = function (marker, bounds) {
  return bounds.contains(marker.getPosition());
};
/**
 * Clears all clusters and markers from the clusterer.
 */


MarkerClusterer.prototype.clearMarkers = function () {
  this.resetViewport(true); // Set the markers a empty array.

  this.markers_ = [];
};
/**
 * Clears all existing clusters and recreates them.
 * @param {boolean} opt_hide To also hide the marker.
 */


MarkerClusterer.prototype.resetViewport = function (opt_hide) {
  // Remove all the clusters
  for (var i = 0, cluster; cluster = this.clusters_[i]; i++) {
    cluster.remove();
  } // Reset the markers to not be added and to be invisible.


  for (var i = 0, marker; marker = this.markers_[i]; i++) {
    marker.isAdded = false;

    if (opt_hide) {
      marker.setMap(null);
    }
  }

  this.clusters_ = [];
};
/**
 *
 */


MarkerClusterer.prototype.repaint = function () {
  var oldClusters = this.clusters_.slice();
  this.clusters_.length = 0;
  this.resetViewport();
  this.redraw(); // Remove the old clusters.
  // Do it in a timeout so the other clusters have been drawn first.

  window.setTimeout(function () {
    for (var i = 0, cluster; cluster = oldClusters[i]; i++) {
      cluster.remove();
    }
  }, 0);
};
/**
 * Redraws the clusters.
 */


MarkerClusterer.prototype.redraw = function () {
  this.createClusters_();
};
/**
 * Calculates the distance between two latlng locations in km.
 * @see http://www.movable-type.co.uk/scripts/latlong.html
 *
 * @param {google.maps.LatLng} p1 The first lat lng point.
 * @param {google.maps.LatLng} p2 The second lat lng point.
 * @return {number} The distance between the two points in km.
 * @private
*/


MarkerClusterer.prototype.distanceBetweenPoints_ = function (p1, p2) {
  if (!p1 || !p2) {
    return 0;
  }

  var R = 6371; // Radius of the Earth in km

  var dLat = (p2.lat() - p1.lat()) * Math.PI / 180;
  var dLon = (p2.lng() - p1.lng()) * Math.PI / 180;
  var a = Math.sin(dLat / 2) * Math.sin(dLat / 2) + Math.cos(p1.lat() * Math.PI / 180) * Math.cos(p2.lat() * Math.PI / 180) * Math.sin(dLon / 2) * Math.sin(dLon / 2);
  var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
  var d = R * c;
  return d;
};
/**
 * Add a marker to a cluster, or creates a new cluster.
 *
 * @param {google.maps.Marker} marker The marker to add.
 * @private
 */


MarkerClusterer.prototype.addToClosestCluster_ = function (marker) {
  var distance = 40000; // Some large number

  var clusterToAddTo = null;
  var pos = marker.getPosition();

  for (var i = 0, cluster; cluster = this.clusters_[i]; i++) {
    var center = cluster.getCenter();

    if (center) {
      var d = this.distanceBetweenPoints_(center, marker.getPosition());

      if (d < distance) {
        distance = d;
        clusterToAddTo = cluster;
      }
    }
  }

  if (clusterToAddTo && clusterToAddTo.isMarkerInClusterBounds(marker)) {
    clusterToAddTo.addMarker(marker);
  } else {
    var cluster = new Cluster(this);
    cluster.addMarker(marker);
    this.clusters_.push(cluster);
  }
};
/**
 * Creates the clusters.
 *
 * @private
 */


MarkerClusterer.prototype.createClusters_ = function () {
  if (!this.ready_) {
    return;
  } // Get our current map view bounds.
  // Create a new bounds object so we don't affect the map.


  var mapBounds = new google.maps.LatLngBounds(this.map_.getBounds().getSouthWest(), this.map_.getBounds().getNorthEast());
  var bounds = this.getExtendedBounds(mapBounds);

  for (var i = 0, marker; marker = this.markers_[i]; i++) {
    if (!marker.isAdded && this.isMarkerInBounds_(marker, bounds)) {
      this.addToClosestCluster_(marker);
    }
  }
};
/**
 * A cluster that contains markers.
 *
 * @param {MarkerClusterer} markerClusterer The markerclusterer that this
 *     cluster is associated with.
 * @constructor
 * @ignore
 */


function Cluster(markerClusterer) {
  this.markerClusterer_ = markerClusterer;
  this.map_ = markerClusterer.getMap();
  this.gridSize_ = markerClusterer.getGridSize();
  this.minClusterSize_ = markerClusterer.getMinClusterSize();
  this.averageCenter_ = markerClusterer.isAverageCenter();
  this.center_ = null;
  this.markers_ = [];
  this.bounds_ = null;
  this.clusterIcon_ = new ClusterIcon(this, markerClusterer.getStyles(), markerClusterer.getGridSize());
}
/**
 * Determins if a marker is already added to the cluster.
 *
 * @param {google.maps.Marker} marker The marker to check.
 * @return {boolean} True if the marker is already added.
 */


Cluster.prototype.isMarkerAlreadyAdded = function (marker) {
  if (this.markers_.indexOf) {
    return this.markers_.indexOf(marker) != -1;
  } else {
    for (var i = 0, m; m = this.markers_[i]; i++) {
      if (m == marker) {
        return true;
      }
    }
  }

  return false;
};
/**
 * Add a marker the cluster.
 *
 * @param {google.maps.Marker} marker The marker to add.
 * @return {boolean} True if the marker was added.
 */


Cluster.prototype.addMarker = function (marker) {
  if (this.isMarkerAlreadyAdded(marker)) {
    return false;
  }

  if (!this.center_) {
    this.center_ = marker.getPosition();
    this.calculateBounds_();
  } else {
    if (this.averageCenter_) {
      var l = this.markers_.length + 1;
      var lat = (this.center_.lat() * (l - 1) + marker.getPosition().lat()) / l;
      var lng = (this.center_.lng() * (l - 1) + marker.getPosition().lng()) / l;
      this.center_ = new google.maps.LatLng(lat, lng);
      this.calculateBounds_();
    }
  }

  marker.isAdded = true;
  this.markers_.push(marker);
  var len = this.markers_.length;

  if (len < this.minClusterSize_ && marker.getMap() != this.map_) {
    // Min cluster size not reached so show the marker.
    marker.setMap(this.map_);
  }

  if (len == this.minClusterSize_) {
    // Hide the markers that were showing.
    for (var i = 0; i < len; i++) {
      this.markers_[i].setMap(null);
    }
  }

  if (len >= this.minClusterSize_) {
    marker.setMap(null);
  }

  this.updateIcon();
  return true;
};
/**
 * Returns the marker clusterer that the cluster is associated with.
 *
 * @return {MarkerClusterer} The associated marker clusterer.
 */


Cluster.prototype.getMarkerClusterer = function () {
  return this.markerClusterer_;
};
/**
 * Returns the bounds of the cluster.
 *
 * @return {google.maps.LatLngBounds} the cluster bounds.
 */


Cluster.prototype.getBounds = function () {
  var bounds = new google.maps.LatLngBounds(this.center_, this.center_);
  var markers = this.getMarkers();

  for (var i = 0, marker; marker = markers[i]; i++) {
    bounds.extend(marker.getPosition());
  }

  return bounds;
};
/**
 * Removes the cluster
 */


Cluster.prototype.remove = function () {
  this.clusterIcon_.remove();
  this.markers_.length = 0;
  delete this.markers_;
};
/**
 * Returns the number of markers in the cluster.
 *
 * @return {number} The number of markers in the cluster.
 */


Cluster.prototype.getSize = function () {
  return this.markers_.length;
};
/**
 * Returns a list of the markers in the cluster.
 *
 * @return {Array.<google.maps.Marker>} The markers in the cluster.
 */


Cluster.prototype.getMarkers = function () {
  return this.markers_;
};
/**
 * Returns the center of the cluster.
 *
 * @return {google.maps.LatLng} The cluster center.
 */


Cluster.prototype.getCenter = function () {
  return this.center_;
};
/**
 * Calculated the extended bounds of the cluster with the grid.
 *
 * @private
 */


Cluster.prototype.calculateBounds_ = function () {
  var bounds = new google.maps.LatLngBounds(this.center_, this.center_);
  this.bounds_ = this.markerClusterer_.getExtendedBounds(bounds);
};
/**
 * Determines if a marker lies in the clusters bounds.
 *
 * @param {google.maps.Marker} marker The marker to check.
 * @return {boolean} True if the marker lies in the bounds.
 */


Cluster.prototype.isMarkerInClusterBounds = function (marker) {
  return this.bounds_.contains(marker.getPosition());
};
/**
 * Returns the map that the cluster is associated with.
 *
 * @return {google.maps.Map} The map.
 */


Cluster.prototype.getMap = function () {
  return this.map_;
};
/**
 * Updates the cluster icon
 */


Cluster.prototype.updateIcon = function () {
  var zoom = this.map_.getZoom();
  var mz = this.markerClusterer_.getMaxZoom();

  if (mz && zoom > mz) {
    // The zoom is greater than our max zoom so show all the markers in cluster.
    for (var i = 0, marker; marker = this.markers_[i]; i++) {
      marker.setMap(this.map_);
    }

    return;
  }

  if (this.markers_.length < this.minClusterSize_) {
    // Min cluster size not yet reached.
    this.clusterIcon_.hide();
    return;
  }

  var numStyles = this.markerClusterer_.getStyles().length;
  var sums = this.markerClusterer_.getCalculator()(this.markers_, numStyles);
  this.clusterIcon_.setCenter(this.center_);
  this.clusterIcon_.setSums(sums);
  this.clusterIcon_.show();
};
/**
 * A cluster icon
 *
 * @param {Cluster} cluster The cluster to be associated with.
 * @param {Object} styles An object that has style properties:
 *     'url': (string) The image url.
 *     'height': (number) The image height.
 *     'width': (number) The image width.
 *     'anchor': (Array) The anchor position of the label text.
 *     'textColor': (string) The text color.
 *     'textSize': (number) The text size.
 *     'backgroundPosition: (string) The background postition x, y.
 * @param {number=} opt_padding Optional padding to apply to the cluster icon.
 * @constructor
 * @extends google.maps.OverlayView
 * @ignore
 */


function ClusterIcon(cluster, styles, opt_padding) {
  cluster.getMarkerClusterer().extend(ClusterIcon, google.maps.OverlayView);
  this.styles_ = styles;
  this.padding_ = opt_padding || 0;
  this.cluster_ = cluster;
  this.center_ = null;
  this.map_ = cluster.getMap();
  this.div_ = null;
  this.sums_ = null;
  this.visible_ = false;
  this.setMap(this.map_);
}
/**
 * Triggers the clusterclick event and zoom's if the option is set.
 */


ClusterIcon.prototype.triggerClusterClick = function () {
  var markerClusterer = this.cluster_.getMarkerClusterer(); // Trigger the clusterclick event.

  google.maps.event.trigger(markerClusterer.map_, 'clusterclick', this.cluster_);

  if (markerClusterer.isZoomOnClick()) {
    // Zoom into the cluster.
    this.map_.fitBounds(this.cluster_.getBounds());
  }
};
/**
 * Adding the cluster icon to the dom.
 * @ignore
 */


ClusterIcon.prototype.onAdd = function () {
  this.div_ = document.createElement('DIV');

  if (this.visible_) {
    var pos = this.getPosFromLatLng_(this.center_);
    this.div_.style.cssText = this.createCss(pos);
    this.div_.innerHTML = this.sums_.text;
  }

  var panes = this.getPanes();
  panes.overlayMouseTarget.appendChild(this.div_);
  var that = this;
  google.maps.event.addDomListener(this.div_, 'click', function () {
    that.triggerClusterClick();
  });
};
/**
 * Returns the position to place the div dending on the latlng.
 *
 * @param {google.maps.LatLng} latlng The position in latlng.
 * @return {google.maps.Point} The position in pixels.
 * @private
 */


ClusterIcon.prototype.getPosFromLatLng_ = function (latlng) {
  var pos = this.getProjection().fromLatLngToDivPixel(latlng);
  pos.x -= parseInt(this.width_ / 2, 10);
  pos.y -= parseInt(this.height_ / 2, 10);
  return pos;
};
/**
 * Draw the icon.
 * @ignore
 */


ClusterIcon.prototype.draw = function () {
  if (this.visible_) {
    var pos = this.getPosFromLatLng_(this.center_);
    this.div_.style.top = pos.y + 'px';
    this.div_.style.left = pos.x + 'px';
    this.div_.style.zIndex = google.maps.Marker.MAX_ZINDEX + 1;
  }
};
/**
 * Hide the icon.
 */


ClusterIcon.prototype.hide = function () {
  if (this.div_) {
    this.div_.style.display = 'none';
  }

  this.visible_ = false;
};
/**
 * Position and show the icon.
 */


ClusterIcon.prototype.show = function () {
  if (this.div_) {
    var pos = this.getPosFromLatLng_(this.center_);
    this.div_.style.cssText = this.createCss(pos);
    this.div_.style.display = '';
  }

  this.visible_ = true;
};
/**
 * Remove the icon from the map
 */


ClusterIcon.prototype.remove = function () {
  this.setMap(null);
};
/**
 * Implementation of the onRemove interface.
 * @ignore
 */


ClusterIcon.prototype.onRemove = function () {
  if (this.div_ && this.div_.parentNode) {
    this.hide();
    this.div_.parentNode.removeChild(this.div_);
    this.div_ = null;
  }
};
/**
 * Set the sums of the icon.
 *
 * @param {Object} sums The sums containing:
 *   'text': (string) The text to display in the icon.
 *   'index': (number) The style index of the icon.
 */


ClusterIcon.prototype.setSums = function (sums) {
  this.sums_ = sums;
  this.text_ = sums.text;
  this.index_ = sums.index;

  if (this.div_) {
    this.div_.innerHTML = sums.text;
  }

  this.useStyle();
};
/**
 * Sets the icon to the the styles.
 */


ClusterIcon.prototype.useStyle = function () {
  var index = Math.max(0, this.sums_.index - 1);
  index = Math.min(this.styles_.length - 1, index);
  var style = this.styles_[index];
  this.url_ = style['url'];
  this.height_ = style['height'];
  this.width_ = style['width'];
  this.textColor_ = style['textColor'];
  this.anchor_ = style['anchor'];
  this.textSize_ = style['textSize'];
  this.backgroundPosition_ = style['backgroundPosition'];
};
/**
 * Sets the center of the icon.
 *
 * @param {google.maps.LatLng} center The latlng to set as the center.
 */


ClusterIcon.prototype.setCenter = function (center) {
  this.center_ = center;
};
/**
 * Create the css text based on the position of the icon.
 *
 * @param {google.maps.Point} pos The position.
 * @return {string} The css style text.
 */


ClusterIcon.prototype.createCss = function (pos) {
  var style = [];
  style.push('background-image:url(' + this.url_ + ');');
  var backgroundPosition = this.backgroundPosition_ ? this.backgroundPosition_ : '0 0';
  style.push('background-position:' + backgroundPosition + ';');

  if (typeof this.anchor_ === 'object') {
    if (typeof this.anchor_[0] === 'number' && this.anchor_[0] > 0 && this.anchor_[0] < this.height_) {
      style.push('height:' + (this.height_ - this.anchor_[0]) + 'px; padding-top:' + this.anchor_[0] + 'px;');
    } else {
      style.push('height:' + this.height_ + 'px; line-height:' + this.height_ + 'px;');
    }

    if (typeof this.anchor_[1] === 'number' && this.anchor_[1] > 0 && this.anchor_[1] < this.width_) {
      style.push('width:' + (this.width_ - this.anchor_[1]) + 'px; padding-left:' + this.anchor_[1] + 'px;');
    } else {
      style.push('width:' + this.width_ + 'px; text-align:center;');
    }
  } else {
    style.push('height:' + this.height_ + 'px; line-height:' + this.height_ + 'px; width:' + this.width_ + 'px; text-align:center;');
  }

  var txtColor = this.textColor_ ? this.textColor_ : 'black';
  var txtSize = this.textSize_ ? this.textSize_ : 11;
  style.push('cursor:pointer; top:' + pos.y + 'px; left:' + pos.x + 'px; color:' + txtColor + '; position:absolute; font-size:' + txtSize + 'px; font-family:Arial,sans-serif; font-weight:bold');
  return style.join('');
}; // Export Symbols for Closure
// If you are not going to compile with closure then you can remove the
// code below.


var window = window || {};
window['MarkerClusterer'] = MarkerClusterer;
MarkerClusterer.prototype['addMarker'] = MarkerClusterer.prototype.addMarker;
MarkerClusterer.prototype['addMarkers'] = MarkerClusterer.prototype.addMarkers;
MarkerClusterer.prototype['clearMarkers'] = MarkerClusterer.prototype.clearMarkers;
MarkerClusterer.prototype['fitMapToMarkers'] = MarkerClusterer.prototype.fitMapToMarkers;
MarkerClusterer.prototype['getCalculator'] = MarkerClusterer.prototype.getCalculator;
MarkerClusterer.prototype['getGridSize'] = MarkerClusterer.prototype.getGridSize;
MarkerClusterer.prototype['getExtendedBounds'] = MarkerClusterer.prototype.getExtendedBounds;
MarkerClusterer.prototype['getMap'] = MarkerClusterer.prototype.getMap;
MarkerClusterer.prototype['getMarkers'] = MarkerClusterer.prototype.getMarkers;
MarkerClusterer.prototype['getMaxZoom'] = MarkerClusterer.prototype.getMaxZoom;
MarkerClusterer.prototype['getStyles'] = MarkerClusterer.prototype.getStyles;
MarkerClusterer.prototype['getTotalClusters'] = MarkerClusterer.prototype.getTotalClusters;
MarkerClusterer.prototype['getTotalMarkers'] = MarkerClusterer.prototype.getTotalMarkers;
MarkerClusterer.prototype['redraw'] = MarkerClusterer.prototype.redraw;
MarkerClusterer.prototype['removeMarker'] = MarkerClusterer.prototype.removeMarker;
MarkerClusterer.prototype['removeMarkers'] = MarkerClusterer.prototype.removeMarkers;
MarkerClusterer.prototype['resetViewport'] = MarkerClusterer.prototype.resetViewport;
MarkerClusterer.prototype['repaint'] = MarkerClusterer.prototype.repaint;
MarkerClusterer.prototype['setCalculator'] = MarkerClusterer.prototype.setCalculator;
MarkerClusterer.prototype['setGridSize'] = MarkerClusterer.prototype.setGridSize;
MarkerClusterer.prototype['setMaxZoom'] = MarkerClusterer.prototype.setMaxZoom;
MarkerClusterer.prototype['onAdd'] = MarkerClusterer.prototype.onAdd;
MarkerClusterer.prototype['draw'] = MarkerClusterer.prototype.draw;
Cluster.prototype['getCenter'] = Cluster.prototype.getCenter;
Cluster.prototype['getSize'] = Cluster.prototype.getSize;
Cluster.prototype['getMarkers'] = Cluster.prototype.getMarkers;
ClusterIcon.prototype['onAdd'] = ClusterIcon.prototype.onAdd;
ClusterIcon.prototype['draw'] = ClusterIcon.prototype.draw;
ClusterIcon.prototype['onRemove'] = ClusterIcon.prototype.onRemove;

Object.keys = Object.keys || function (o) {
  var result = [];

  for (var name in o) {
    if (o.hasOwnProperty(name)) result.push(name);
  }

  return result;
};

if (true) {
  module.exports = MarkerClusterer;
}

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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