(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["maps"],{

/***/ "./assets/images/map-pin-location.svg":
/*!********************************************!*\
  !*** ./assets/images/map-pin-location.svg ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB3aWR0aD0iNDcuNTc5IiBoZWlnaHQ9IjU4IiB2aWV3Qm94PSIwIDAgNDcuNTc5IDU4Ij4NCiAgPGRlZnM+DQogICAgPGZpbHRlciBpZD0iRXhjbHVzaW9uXzEzIiB4PSIwIiB5PSIwIiB3aWR0aD0iNDcuNTc5IiBoZWlnaHQ9IjU4IiBmaWx0ZXJVbml0cz0idXNlclNwYWNlT25Vc2UiPg0KICAgICAgPGZlT2Zmc2V0IGR5PSIzIiBpbnB1dD0iU291cmNlQWxwaGEiLz4NCiAgICAgIDxmZUdhdXNzaWFuQmx1ciBzdGREZXZpYXRpb249IjMiIHJlc3VsdD0iYmx1ciIvPg0KICAgICAgPGZlRmxvb2QgZmxvb2Qtb3BhY2l0eT0iMC4xNjEiLz4NCiAgICAgIDxmZUNvbXBvc2l0ZSBvcGVyYXRvcj0iaW4iIGluMj0iYmx1ciIvPg0KICAgICAgPGZlQ29tcG9zaXRlIGluPSJTb3VyY2VHcmFwaGljIi8+DQogICAgPC9maWx0ZXI+DQogIDwvZGVmcz4NCiAgPGcgdHJhbnNmb3JtPSJtYXRyaXgoMSwgMCwgMCwgMSwgMCwgMCkiIGZpbHRlcj0idXJsKCNFeGNsdXNpb25fMTMpIj4NCiAgICA8cGF0aCBpZD0iRXhjbHVzaW9uXzEzLTIiIGRhdGEtbmFtZT0iRXhjbHVzaW9uIDEzIiBkPSJNMTQuODEyLDQwYS4wMjkuMDI5LDAsMCwxLS4wMjItLjAwOGMtLjA0OC0uMDI0LTMuNzg5LTQuMzU5LTcuNDIxLTkuNTUzQTY5LjEwOSw2OS4xMDksMCwwLDEsMi4zLDIyLjE2N0MuNzc0LDE5LjEzNCwwLDE2LjY1MiwwLDE0Ljc5QTE0Ljc5LDE0Ljc5LDAsMCwxLDI1LjI0Nyw0LjMzMiwxNC42OTMsMTQuNjkzLDAsMCwxLDI5LjU3OSwxNC43OWExOC4yMTcsMTguMjE3LDAsMCwxLTIuMiw3LjM0Myw2Ni45NjgsNjYuOTY4LDAsMCwxLTQuOSw4LjI4OEMxOC45MTgsMzUuNjYyLDE1LjIsNDAsMTQuODEyLDQwWk0xNSw4LjY5NWE2LDYsMCwxLDAsNiw2QTYuMDA3LDYuMDA3LDAsMCwwLDE1LDguNjk1WiIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoOSA2KSIgZmlsbD0iI2E2OGUzZiIvPg0KICA8L2c+DQo8L3N2Zz4NCg=="

/***/ }),

/***/ "./assets/scripts/constants.js":
/*!*************************************!*\
  !*** ./assets/scripts/constants.js ***!
  \*************************************/
/*! exports provided: GOOGLE_API_KEY */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GOOGLE_API_KEY", function() { return GOOGLE_API_KEY; });
var GOOGLE_API_KEY = 'AIzaSyAGsKZ5PP8iURMpB4kRQKcpLQps-szGeqw';

/***/ }),

/***/ "./assets/scripts/maps.js":
/*!********************************!*\
  !*** ./assets/scripts/maps.js ***!
  \********************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {/* harmony import */ var _utils_externalScriptLoader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/externalScriptLoader */ "./assets/scripts/utils/externalScriptLoader.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./assets/scripts/constants.js");
/* harmony import */ var _images_map_pin_location_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../images/map-pin-location.svg */ "./assets/images/map-pin-location.svg");
/* harmony import */ var _images_map_pin_location_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_images_map_pin_location_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _google_markerclusterer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @google/markerclusterer */ "./node_modules/@google/markerclusterer/src/markerclusterer.js");
/* harmony import */ var _google_markerclusterer__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_google_markerclusterer__WEBPACK_IMPORTED_MODULE_3__);
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }





var center;
var markerIcon;

var markers = _toConsumableArray(document.querySelectorAll('.marker'));

var searchInput = document.getElementById('map-search');
var clusterMarkers = [];
var map;

var addMarkers = function addMarkers() {
  var bounds = new google.maps.LatLngBounds();

  var _iterator = _createForOfIteratorHelper(markers.entries()),
      _step;

  try {
    var _loop = function _loop() {
      var _step$value = _slicedToArray(_step.value, 2),
          index = _step$value[0],
          marker = _step$value[1];

      var latlng = new google.maps.LatLng(parseFloat(marker.dataset.lat), parseFloat(marker.dataset.lng));

      if (index === 0) {
        center = latlng;
      }

      var newMarker = new google.maps.Marker({
        position: latlng,
        icon: markerIcon
      });
      var id = marker.dataset.index;

      if (typeof id !== 'undefined') {
        newMarker.addListener('click', function () {
          var scroller = document.getElementById('scroller');
          var anchor = $("#".concat(id));
          var position = anchor.position().top + scroller.scrollTop;
          anchor.parent().addClass('fade-articles');
          anchor.addClass('active');
          $('.scroll-container').animate({
            scrollTop: position
          });

          if (marker.innerHTML) {
            var infowindow = new google.maps.InfoWindow({
              content: marker.innerHTML
            });
            infowindow.open(map, newMarker);
          }
        });
      }

      bounds.extend(latlng);
      clusterMarkers.push(newMarker);
    };

    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      _loop();
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  if (clusterMarkers.length !== 1) {
    map.fitBounds(bounds);
  }

  map.setCenter(center);
};

function createSearchBox() {
  // Create Google Places SearchBox from Dom input
  var searchBox = new google.maps.places.SearchBox(searchInput);
  searchBox.addListener('places_changed', function () {
    var places = searchBox.getPlaces();
    var bounds = new google.maps.LatLngBounds();

    if (places.length === 0) {
      return;
    }

    places.forEach(function (place) {
      if (!place.geometry) {
        return;
      }

      if (place.geometry.viewport) {
        bounds.union(place.geometry.viewport);
      } else {
        bounds.extend(place.geometry.location);
      }
    });
    map.fitBounds(bounds);
  });
}

function initMap() {
  // Create google map
  map = new google.maps.Map(document.getElementById('google-map'), {
    zoom: 8,
    disableDefaultUI: true
  });
  markerIcon = {
    url: _images_map_pin_location_svg__WEBPACK_IMPORTED_MODULE_2___default.a,
    size: new google.maps.Size(48, 58),
    origin: new google.maps.Point(0, 0),
    anchor: new google.maps.Point(15, 40)
  }; // Add all markers

  addMarkers(); // Create clusters from markers

  new _google_markerclusterer__WEBPACK_IMPORTED_MODULE_3___default.a(map, clusterMarkers, {
    styles: [{
      url: '/content/themes/isle-mill-theme/dist/images/map-pin-sum.svg',
      height: 58,
      width: 48,
      textColor: '#ffffff',
      textSize: 14,
      anchor: [12, 0]
    }]
  });

  if (searchInput !== null) {
    createSearchBox();
  }
}

Object(_utils_externalScriptLoader__WEBPACK_IMPORTED_MODULE_0__["default"])("https://maps.googleapis.com/maps/api/js?key=".concat(_constants__WEBPACK_IMPORTED_MODULE_1__["GOOGLE_API_KEY"], "&libraries=places")).then(function () {
  initMap();
});
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "jquery")))

/***/ }),

/***/ "./assets/scripts/utils/externalScriptLoader.js":
/*!******************************************************!*\
  !*** ./assets/scripts/utils/externalScriptLoader.js ***!
  \******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return loadScript; });
function loadScript(src) {
  return new Promise(function (resolve) {
    var script = document.createElement('script');
    script.src = src;
    script.type = 'text/javascript';
    script.async = true;
    script.onload = resolve;
    document.body.appendChild(script);
  });
}

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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