<?php

use Blue2\Scruffy\Controllers\UserController;
use Blue2\Scruffy\Controllers\WooCommerceController;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

get_header('shop');
global $product;

while (have_posts()) {
    the_post();
    $afterCare = get_field('after_care');
    $afterCareText = is_array($afterCare) ? (implode(', ', $afterCare)) : '';

    $backgroundImage = get_field('background_image');
    $backgroundImage = wp_get_attachment_image_url($backgroundImage, 'banner');

    $imageChange = get_field('change_image_on_variant_swap'); ?>
    <div class="product-page wrap-large product-collection">
        <section class="feature">
            <div class="feature__image">
                <?php woocommerce_breadcrumb(); ?>
                <div class="feature__image-inner">
                    <?= get_the_post_thumbnail(); ?>
                    <div class="fixed-background" style="background-image:url('<?= $backgroundImage; ?>')"></div>
                </div>
            </div>
            <div class="feature__content">
                <?php do_action('woocommerce_before_single_product'); ?>
                <p><?= $product->get_sku(); ?></p>
                <div class="heading-contain">
                    <h1><?= get_the_title() ?></h1>
                </div>
                <div class="content">
                    <?php the_content(); ?>
                </div>
                <?php if (get_field('width')) { ?>
                    <div class="product-details">
                        <h2 class="col-md-12">Fabric Details</h2>
                        <?php if (get_field('composition')) { ?>
                            <div class="detail order-md-1">
                                <p class="label">Composition</p>
                                <p><?= get_field('composition'); ?></p>
                            </div>
                        <?php }
                        if (get_field('width')) { ?>
                            <div class="detail order-md-3">
                                <p class="label">Width</p>
                                <p class="prod-width"><?= get_field('width'); ?></p>
                            </div>
                        <?php }
                        if (get_field('weight')) { ?>
                            <div class="detail order-md-5">
                                <p class="label">Approx Weight</p>
                                <p class="prod-weight"><?= get_field('weight'); ?></p>
                            </div>
                        <?php }
                        if (get_field('selvedge')) { ?>
                            <div class="detail order-md-5">
                                <p class="label">Selvedge</p>
                                <p><?= get_field('selvedge'); ?></p>
                            </div>
                        <?php }
                        if (get_field('pattern')) { ?>
                            <div class="detail order-md-5">
                                <p class="label">Pattern</p>
                                <p class="prod-pattern"><?= get_field('pattern'); ?></p>
                            </div>
                        <?php }
                        if ($afterCareText) { ?>
                            <div class="detail order-md-8">
                                <p class="label">After Care</p>
                                <p><?= $afterCareText ?></p>
                            </div>
                        <?php }
                        global $wp_query;
                        $category = get_the_terms(get_the_ID(), 'product_cat');
                        $file = get_field('technical_pdf', $category[0]);
                        if (!$file) {
                            $file = get_field('technical_pdf');
                        }
                        ?>
                        <?php if ($file) { ?>
                            <div class="detail order-md-6">
                                <a href="<?= $file['url'] ?>" target="_blank" rel="noopener" download>Technical
                                    specifications
                                    (pdf)</a>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
                <?php
                if ($product->is_type('variable')) { ?>
                    <div data-toggle="modal" data-target="#variation-modal" class="select-modal">
                        <?php $availableVariations = $product->get_available_variations(); ?>
                        <?php if (array_key_exists('attribute_colour', $availableVariations[0]['attributes'])) { ?>
                            <h2>Colour:</h2>
                            <div class="modal-option">
                                <img alt="<?= $availableVariations[0]['image']['alt']; ?>"
                                     src="<?= $availableVariations[0]['image']['thumb_src']; ?>">
                                <span>Please select an option</span>
                                <i class="far fa-chevron-down"></i>
                            </div>
                        <?php } else {
                            $keys = array_column($availableVariations, 'attributes');
                            array_multisort($keys, SORT_ASC, $availableVariations); ?>
                            <h2>Size:</h2>
                            <select class="default-select">
                                <?php foreach ($availableVariations as $variation) { ?>
                                    <option value="<?= $variation['variation_id']; ?>" ><?= reset($variation['attributes']); ?></option>
                                <?php } ?>
                            </select>
                        <?php } ?>
                    </div>
                    <?php if (array_key_exists('attribute_colour', $availableVariations[0]['attributes'])) { ?>
                        <div id="variation-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                            <?php foreach ($availableVariations as $variation) {
                                                if (array_key_exists('attribute_colour', $variation['attributes'])) { ?>
                                                    <div class="product-box col-md-3"
                                                         data-changeable="<?= $imageChange ?>"
                                                         data-variation-id="<?= $variation['variation_id'] ?>"
                                                         data-option="<?= reset($variation['attributes']); ?>"
                                                         data-product-thumb="<?= $variation['image']['url']; ?>"
                                                        <?php if (strpos($variation['dimensions']['width'], 'field_')) { ?>
                                                            data-width="<?= $variation['dimensions']['width']; ?>cm"
                                                        <?php } ?>
                                                        <?php if (strpos($variation['dimensions']['weight'], 'field_')) { ?>
                                                            data-weight="<?= $variation['dimensions']['weight']; ?>gsm"
                                                        <?php } ?>
                                                        <?php if ($variation['variation_description'] != '') { ?>
                                                            data-notes="<?= $variation['variation_description']; ?>"
                                                        <?php } ?>
                                                         data-height="<?= $variation['dimensions']['height']; ?>">
                                                        <img alt="<?= $variation['image']['alt']; ?>"
                                                             src="<?= $variation['image']['thumb_src']; ?>">
                                                        <p><?= reset($variation['attributes']); ?></p>
                                                    </div>
                                                <?php } ?>
                                            <?php }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <?php } ?>
                <div class="order-contain row">
                    <?php if (has_term('brochure', 'product_tag')) {
                        if ($brochure = get_field('brochure', $category[0])) { ?>
                            <div class="col-12 col-md-6 col-xl-6">
                                <a href="<?= $brochure['link'] ?>" title="Brochure" class="btn btn-primary" download>
                                    Download Brochure
                                </a>
                            </div>
                        <?php }
                    } else if (is_user_logged_in()) {
                        if (in_array(UserController::APPROVED_USER_ROLE, wp_get_current_user()->roles)) { ?>
                            <div class="col-12 col-md-6 col-xl-6">
                                <button
                                        type="button"
                                        data-product_id="<?php the_ID(); ?>"
                                        data-toggle="modal"
                                        data-target="#exampleModalCenter"
                                        class="btn btn-primary product_type_simple">
                                    Request a Returnable Sample
                                </button>
                            </div>
                        <?php } ?>

                        <div class="col-12 col-md-6 col-xl-6">
                            <script>const ajaxUrl = '<?= admin_url('admin-ajax.php') ?>';</script>
                            <?php
                            if ($product->is_type('variable') && !get_field('disable_ordering')) {
                                WooCommerceController::variationAddToCart();
                            } else if (!get_field('disable_ordering')) {
                                woocommerce_template_loop_add_to_cart();
                            } ?>
                        </div>

                        <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                             aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h2 class="modal-title" id="exampleModalCenterTitle">Request a sample</h2>
                                        <i class="far fa-times" data-dismiss="modal" class="float-right"></i>
                                    </div>
                                    <div class="modal-body">
                                        <div class="container-fluid">
                                            <p>
                                                Returnable samples are 50cm x 50cm. The Isle Mill will send these to you
                                                for free, but they must be returned within 6 weeks. If you fail to
                                                return the sample in agreed time limit you will be charged £10+VAT.
                                            </p>
                                            <p>
                                                If you want to order more than one returnable sample, please list all
                                                details below.
                                            </p>

                                            <?php $contactForm = get_field('request_sample_contact_form', 'option'); ?>
                                            <?= do_shortcode($contactForm); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                        <div class="col-12 col-lg-6 col-xl-6">
                            <?php woocommerce_template_loop_add_to_cart(['class' => 'btn btn--no-fill add-cart ']); ?>
                        </div>
                        <div class="col-12 col-lg-6">
                            <p>Trade accounts, <a href="<?= home_url('my-account') ?>">login or register here</a>
                                to order samples</p>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </section>

        <?php if ($caseStudy = get_field('featured_case_study')) { ?>
            <section class="featured-case-study text-center"
                     style="background-image: url(<?= get_the_post_thumbnail_url($caseStudy->ID) ?>);">
                <div class="intro--front-page" style="color: <?= get_field('heading_colour') ?>;">
                    <h2><?= $caseStudy->post_title; ?></h2>
                    <a href="<?= get_permalink($caseStudy->permalink); ?>" class="btn btn-primary">Read more</a>
                    <a href="<?= home_url('case-studies'); ?>" class="btn btn-primary">View all</a>
                </div>
            </section>
        <?php }
        do_action('woocommerce_after_single_product');
        if ($product->get_upsell_ids()) {
            woocommerce_upsell_display();
        } else {
            get_template_part('templates/parts/global-upsells');
        }
        ?>
    </div>
    <?php
    get_template_part('woocommerce/parts/featured-area');

    get_template_part('woocommerce/parts/cross-sells');


    get_footer('shop');

} ?>
