<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if (empty($product) || !$product->is_visible()) {
    return;
}
?>

<article <?php post_class(); ?>>
    <a class="product-wrap d-flex flex-column">
        <?php do_action('woocommerce_before_shop_loop_item_title'); ?>
        <h3><?= get_the_title(); ?></h3>
        <div data-toggle="modal" data-target="#variation-modal-<?= $product->get_id(); ?>" class="more-colors"
             data-product-id="" data-option="">+More options
        </div>
        <?php
        if ($product->is_type('variable')) {
            $availableVariations = $product->get_available_variations(); ?>
            <div id="variation-modal-<?= $product->get_id(); ?>" class="modal fade product-modal" tabindex="-1"
                 role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <?php foreach ($availableVariations as $variation) { ?>
                                    <div class="product-box col-6 col-md-3"
                                         data-product-id="<?= $product->get_id(); ?>"
                                         data-variation-id="<?= $variation['variation_id']; ?>"
                                         data-variation="<?= reset($variation['attributes']); ?>"
                                         data-product-thumb="<?= $variation['image']['thumb_src']; ?>">
                                        <img alt="<?= $variation['image']['alt']; ?>"
                                             src="<?= $variation['image']['thumb_src']; ?>">
                                        <p><?= reset($variation['attributes']); ?></p>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </a>
</article>
