<?php

namespace Blue2\Scruffy\Controllers;


class ClanTartanController
{

    public static function getClanTartansByFirstLetter($letter)
    {
        global $wpdb;

        if (isset($_POST)) {
            $familyName = $_POST['familyName'];
            $colour = $_POST['searchColour'];
        }

        $searchTerm = isset($familyName) ? $familyName : $letter;

        $searchSQL = "SELECT * 
                        FROM pex_houseofedgar_posts AS p
                        LEFT JOIN pex_houseofedgar_term_relationships AS tr ON p.ID = tr.object_id
                        WHERE p.post_type = 'product' 
                        AND p.post_title LIKE '%" . $searchTerm . "%'
                        AND p.post_status = 'publish'
                        AND (tr.term_taxonomy_id = 57 OR tr.term_taxonomy_id = 17 OR tr.term_taxonomy_id = 20)
                        GROUP BY p.ID
                        ORDER BY p.post_title ASC";

        $findTartansByFirstLetter = $wpdb->get_results($searchSQL);

        if ($findTartansByFirstLetter) {
            foreach ($findTartansByFirstLetter as $tartan) { ?>
                <article class="product type-product status-publish has-post-thumbnail instock purchasable">
                    <a class="product-wrap d-flex flex-column" href="<?= get_the_permalink($tartan->ID); ?>">
                        <?= get_the_post_thumbnail($tartan->ID, 'prod-thumbnail'); ?>
                        <h3><?= get_the_title($tartan->ID); ?></h3>
                        <div class="more-colors">+More options</div>
                    </a>
                </article>
            <?php }
        }else{
            ?>
            <div class="message">Sorry no tartans found.</div>
            <?php
        }
    }
}
