<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     3.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}
if ($upsells) { ?>
    <section class="intro container text-center">
        <div class="intro__content col-12" data-aos="zoom-out" data-aos-anchor-placement="top-bottom">
            <h2>Pair it with</h2>
        </div>
    </section>

    <section class="product-list">
        <div class="row justify-content-center">
            <?php foreach ($upsells as $upsell) { ?>
                <?php $post_object = get_post($upsell->get_id());
                setup_postdata($GLOBALS['post'] =& $post_object);
                wc_get_template_part('content', 'product'); ?>
            <?php } ?>
        </div>
    </section>
<?php }

wp_reset_postdata();
