<?php
if(!is_home() && !is_single() && get_field('hide_stockist_search') !== true) { ?>
    <div class="stockist-footer">
        <div class="wrap-large">
            <section class="stockist-wrap container">
                <div class="find-stockist">Find a Stockist</div>
                <div class="stockist-info">
                    <p>
                        If you need help with the stockist finder or you can’t find a stockist near you, please contact us and
                        our team will be happy to help.
                    </p>
                    <a href="/stockists">VIEW ALL <i class="far fa-arrow-right"></i></a>
                </div>
                <div class="trade-account">Apply for a trade account</div>
                <div class="trade-info">
                    <p>
                        Please download our application form below and return to <a href="mailto:sales@houseofedgar.com">sales@houseofedgar.com</a>
                    </p>
                    <a target="_blank" href="<?= wp_get_attachment_url(get_field('trade_account_application', 'options')) ?>">DOWNLOAD <i class="far fa-arrow-right"></i></a>
                </div>
            </section>
        </div>
    </div>
<?php } ?>

<footer class="site-footer wrap-large">
    <section class="footer container">
        <div class="footer-menu footer-menu-one">
            <?php
            if (has_nav_menu('footer_menu_one')) {
                wp_nav_menu(['theme_location' => 'footer_menu_one',]);
            }
            ?>
        </div>
        <div class="footer-menu footer-menu-two">
            <?php
            if (has_nav_menu('footer_menu_two')) {
                wp_nav_menu(['theme_location' => 'footer_menu_two',]);
            }
            ?>
        </div>
        <div class="footer-menu footer-menu-three">
            <?php
            if (has_nav_menu('footer_menu_three')) {
                wp_nav_menu(['theme_location' => 'footer_menu_three',]);
            }
            ?>
        </div>
        <div class="newsletter">
            <div class="footer-menu footer-menu-three">
                <?php
                if (has_nav_menu('footer_menu_four')) {
                    wp_nav_menu(['theme_location' => 'footer_menu_four',]);
                }
                ?>
            </div>
            <nav class="social-media">
                <?php if (have_rows('social_media_channels', 'option')) { ?>
                    <p>
                        <?php
                        while (have_rows('social_media_channels', 'option')) {
                            the_row();
                            ?>
                            <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i
                                        class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a>
                            <?php
                        }
                        ?>
                    </p>
                <?php } ?>
            </nav>

        </div>
        <div class="logo logo-one"></div>
        <div class="logo logo-two"></div>
        <div class="copyright">©2019 The House of Edgar</div>
        <div class="privacy-menu">
            <a href="/privacy">Privacy Policy</a>
            <p>website by <?= do_shortcode( '[blue2_logo type="dark"]' ); ?></p>
        </div>
    </section>

</footer>
