<?php

namespace Blue2\Scruffy\Controllers;


class BuildAnOutfitController
{
    public function __construct()
    {
        $this->registerActions();
    }

    private function registerActions()
    {
        add_action('wp_ajax_buildSteps', [$this, 'buildSteps']);
        add_action('wp_ajax_nopriv_buildSteps', [$this, 'buildSteps']);

        add_action('init', [$this, 'startProductSession']);
    }

    public static function getCorrectProductsForStep($step)
    {
        ?>
        <script>
            const ajaxUrl = '<?= admin_url('admin-ajax.php') ?>';
            console.log(ajaxUrl);
        </script>
        <?php
        $args = [
            'post_type' => 'product',
            'posts_per_page' => -1,
            'category' => $step,
            'post_status' => 'publish',
            'tax_query' => [
                [
                    'taxonomy' => 'product_cat',
                    'field' => 'slug',
                    'terms' => [$step],
                ],
            ],
        ];
        $stepQuery = new \WP_Query($args);
        if ($stepQuery->have_posts()) {
            while ($stepQuery->have_posts()) {
                $stepQuery->the_post();
                do_action('woocommerce_shop_loop');
                wc_get_template_part('content-product-outfit-builder');
            }
        }
    }

    public static function getCorrectStep()
    {
        if (empty($_GET['step'])) {
            $step = 'kilts';
        } else {
            $step = $_GET['step'];
        }
        $steps = [];
        switch ($step) {
            case null:
            case 'kilts':
                $steps = [
                    'current-step' => 'kilts',
                    'next-step' => 'kilt-jackets',
                ];
                break;
            case 'kilt-jackets':
                $steps = [
                    'current-step' => 'kilt-jackets',
                    'next-step' => 'ties',
                ];
                break;
            case 'ties':
                $steps = [
                    'current-step' => 'ties',
                    'next-step' => 'flashes',
                ];
                break;
            case 'flashes':
                $steps = [
                    'current-step' => 'flashes',
                    'next-step' => 'kilt-hoses',
                ];
                break;
            case 'kilt-hoses':
                $steps = [
                    'current-step' => 'kilt-hoses',
                    'next-step' => 'plaid',
                ];
                break;
            case 'plaid':
                $steps = [
                    'current-step' => 'plaid',
                    'next-step' => 'complete',
                ];
                break;
            case 'complete':
                $steps = [
                    'current-step' => 'complete',
                    'next-step' => 'complete',
                ];
                break;
        }
        return $steps;
    }

    public static function buildOutfitLink()
    {
        $outfitLink = '';
        if (isset($_SESSION['products'])) {
            $outfitLink = add_query_arg([
                'kilts' => $_SESSION['products']['kilts']['variation'],
                'kilt-jackets' => $_SESSION['products']['kilt-jackets']['variation'],
                'ties' => $_SESSION['products']['ties']['variation'],
                'flashes' => $_SESSION['products']['flashes']['variation'],
                'kilt-hoses' => $_SESSION['products']['kilt-hoses']['variation'],
                'plaid' => $_SESSION['products']['plaid']['variation'],
            ]);
        }

        return $outfitLink;
    }

    public static function outputCorrectBuiltProducts()
    {

        if (!isset($_SESSION['products']) && isset($_GET['kilts'])) {
            foreach ($_GET as $key => $product) {
                if ($key != 'step') {
                    $_SESSION['products'][$key] = [
                        'product' => $product,
                    ];
                }
            }
            foreach ($_SESSION['products'] as $key => $sessionProduct) {
                ?>
                <div class="col-md-12">
                    <?php $product = get_product($sessionProduct['product']); ?>
                    <a href="<?= get_permalink($product->get_id()); ?>" class="product-build-block">
                        <div class="image"><?= $product->get_image(); ?></div>
                        <div class="content">
                            <h3><?= $product->get_title(); ?></h3>
                            <div class="product-option">
                                <span><?= isset($sessionProduct['option']) ? $sessionProduct['option'] : reset($product->get_attributes()); ?></span>
                            </div>
                        </div>
                    </a>
                </div>
            <?php }
        } else if (isset($_SESSION['products'])) {
            foreach ($_SESSION['products'] as $key => $sessionProduct) { ?>
                <div class="col-md-12">
                    <?php $product = get_product($sessionProduct['product']); ?>
                    <a href="<?= get_permalink($product->get_id()); ?>" class="product-build-block">
                        <div class="image"><?= isset($sessionProduct['variation']) ? get_product((int)$sessionProduct['variation'])->get_image() : $product->get_image(); ?></div>
                        <div class="content">
                            <h3><?= $product->get_title(); ?></h3>
                            <div class="product-option">
                                <span><?= isset($sessionProduct['option']) ? $sessionProduct['option'] : reset($product->get_attributes()); ?></span>
                            </div>
                        </div>
                    </a>
                </div>
            <?php }
        } else if ((!isset($_SESSION['products']) && !isset($_GET['kilts']))) { ?>
            <div class="col-md-12">Unfortunately that link no longer works, please feel free to try building the outfit
                again.
            </div>
        <?php }
    }

    function startProductSession()
    {

        if (session_status() == PHP_SESSION_NONE) {
            session_name("products_session");
            session_start();
        }
    }

    public function buildSteps()
    {
        $_SESSION['products'][$_POST['step']] = [
            'product' => $_POST['productId'],
            'variation' => $_POST['productVariationId'],
            'option' => $_POST['productOption'],
            'productMainImage' => $_POST['productMainImage'],
            'productThumb' => $_POST['productThumb'],
        ];

        wp_die();
    }
}
