// Used to merge config object
const merge = require('webpack-merge');
// Used to minify javascript
const TerserPlugin = require('terser-webpack-plugin');
// Used to minify css
const OptimizeCSSAssetsPlugin = require('optimize-css-assets-webpack-plugin');
// Used to optimise and compress images
const ImageminPlugin = require('imagemin-webpack-plugin').default;
// Image optimisation plugin to support MozJPEG Encoder Project
const imageminMozjpeg = require('imagemin-mozjpeg');
// Import the base config
const common = require('./webpack.config.js');
// Merge our base config with production config options
module.exports = merge(common(), {
    optimization: {
        // Provide webpack with plugins for minification
        minimizer: [new TerserPlugin(), new OptimizeCSSAssetsPlugin({})],
    },
    plugins: [
        // Minify our images
        new ImageminPlugin({
            test: /\.(jpe?g|png|gif|svg)$/i, // File types that minification is applied to
            optipng: { optimizationLevel: 7 },
            gifsicle: { optimizationLevel: 3 },
            pngquant: { quality: '65-90', speed: 4 },
            svgo: { removeUnknownsAndDefaults: false, cleanupIDs: false },
            plugins: [imageminMozjpeg({ quality: 75 })],
        }),
    ],
});
