<?php

use Blue2\Scruffy\Utils;

$postThumb = get_the_post_thumbnail_url(null, 'full');
$backgroundImage = get_field('background_image') ?: "";
$tartanField = get_field('tartan_colour');
$tartanColour = $tartanField ? strtolower($tartanField) . '-tartan' : 'green-tartan';
$postThumb = get_the_post_thumbnail_url(null, 'full');

$latestPostsArgs = [
    'post_type' => 'post',
    'posts_per_page' => 3,
];

?>
<div class="custom-default-layout">
    <section class="offset-section container default-hero tartan-default"
             <?php if ($backgroundImage) { ?>style="background:#fff;" <?php } ?>>
        <div class="offset-feature wrap-large" style="background-image:url('<?= $postThumb; ?>');">
            <div class="featured-image d-md-none">
                <img src="<?= $postThumb; ?>" alt=""/>
            </div>
        </div>
    </section>
</div>

<div class="custom-default-layout wrap-large">
    <div class="row">
        <div class="col-md-4">
            <h1><?php the_title() ?></h1>
            <p><?= get_the_date() ?></p>
        </div>
        <div class="col-md-8"><?php the_content(); ?></div>
    </div>
</div>
<div class="page-wrap" style="position: relative;">
    <?php if (have_rows('image_gallery')) {
        while (have_rows('image_gallery')) {
            the_row(); ?>
            <section class="parallax-grid">
                <div class="content d-md-none">
                    <div class="title"><?= get_sub_field('title') ?></div>
                    <div class="text"><?= get_sub_field('text_block') ?></div>
                </div>
                <div class="gallery gallery__background row">
                    <div class="gallery__background--col1 col-md-7">
                        <?php
                        $i = 0;
                        foreach (get_sub_field('gallery') as $image) {
                            if ($i == 2) {
                                echo '</div><div class="gallery__background--col2 col-md-5">';
                            }
                            ?>
                            <img alt="<?= $image['alt']; ?>" data-rellax-speed="<?= $i; ?>" class="image__<?= $i; ?>"
                                 src="<?= $image['url']; ?>">
                            <?php
                            $i++;
                        }
                        ?>
                    </div>
                </div>

                <div class="wrap-large">
                    <div class="gallery gallery--foreground">

                        <?php
                        $i = 0;
                        foreach (get_sub_field('gallery_foreground') as $image) { ?>
                            <div class="grid-icon-row">
                                <?php
                                if ($i == 1) {
                                    ?>
                                    <div class="content d-none d-md-block">
                                        <div class="title"><?= get_sub_field('title') ?></div>
                                        <div class="text"><?= get_sub_field('text_block') ?></div>
                                    </div>
                                    <img alt="<?= $image['alt']; ?>" data-rellax-speed="<?= $i; ?>"
                                         class="rellax parrallax-image parrallax-image__<?= $i; ?>"
                                         src="<?= $image['url']; ?>">
                                    <?php
                                } else {
                                    ?>
                                    <img alt="<?= $image['alt']; ?>" data-rellax-speed="<?= $i; ?>"
                                         class="rellax parrallax-image parrallax-image__<?= $i; ?>"
                                         src="<?= $image['url']; ?>">
                                    <?php
                                }
                                ?>
                            </div>
                            <?php
                            $i++;
                        }
                        ?>
                    </div>
                </div>
            </section>
        <?php }
    } ?>
</div>
<div class="custom-default-layout wrap-large">
    <div class="row view-more-posts">
        <div class="col-md-12"><h2>View more</h2></div>
        <?php
        $latestPosts = new WP_Query($latestPostsArgs);
        if ($latestPosts->have_posts()) {
            while ($latestPosts->have_posts()) {
                $latestPosts->the_post(); ?>
                <a href="<?php the_permalink() ?>" class="extra-post col-md-4">
                    <?php the_post_thumbnail(); ?>
                    <span><?= get_the_date(); ?></span>
                    <h2><?php the_title(); ?></h2>
                </a>
            <?php }
        }
        ?>
    </div>
</div>