<?php
$products = get_sub_field('products');

if ($products != false) { ?>
    <section class="mentioned-products">
        <div class="mentioned-products__content product-list">
            <?php foreach ($products as $product) {
                $variation = wc_get_product($product->ID);
                $image = wp_get_attachment_image_src($variation->get_image_id(), 'medium');
                $name = $variation->get_name();
                ?>
                <article class="product">
                    <img src="<?= $image[0] ?>" alt="<?= $name ?> Thumbnail" class="img-fluid">
                    <p><?= $variation->get_sku(); ?></p>
                    <h3><?= $variation->get_name(); ?></h3>
                    <a href="#" class="btn btn--no-fill btn__fullwidth">Order Sample</a>
                </article>
            <?php } ?>
        </div>
    </section>
<?php } ?>
