<?php
$companyName = get_field('company_name', 'option');
$contactEmail = get_field('contact_email_address', 'option');
$contactNumber = get_field('contact_phone_number', 'option');

$companyLocation = get_field('company_location', 'option');
$postCode = get_field('post_code', 'option');
if ($companyLocation !== false) {
    $address = explode(', ', $companyLocation['address']);
}

?>

<div class="contact-page padding-wrap">
    <div class="row">
        <div class="col-xl-6 contact-area">
            <div class="contact-page__content clearfix">
                <h1><?php the_title(); ?></h1>
                <div class="intro">
                    <?php the_content(); ?>
                    <div class="contact__content">
                        <?php if ($contactEmail !== false) { ?>
                            <p>E: <a href="mailto:<?= $contactEmail ?>"><?= $contactEmail ?></a></p>
                        <?php } ?>
                        <?php if ($contactNumber !== false) { ?>
                            <p>T: <a href="tel:<?= $contactNumber ?>"><?= $contactNumber ?></a></p>
                        <?php } ?>
                    </div>
                    <div class="contact__address">
                        <?php if ($companyName !== false) { ?>
                            <p class="title"><?= $companyName ?></p>
                        <?php } ?>
                        <?php if (isset($address)) {
                            foreach ($address as $line) { ?>
                                <p><?= $line ?></p>
                            <?php }
                        }

                        if ($postCode !== false) { ?>
                            <p><?= $postCode ?></p>
                        <?php } ?>
                    </div>

                </div>

                <div class="enquiry-form">
                    <h2>General Enquiries</h2>
                    <?php echo do_shortcode('[contact-form-7 id="3205" title="Contact Page Form"]'); ?>
                </div>
            </div>
        </div>
        <div class="col-xl-6 main-map">
            <div class="google-map" id="google-map">
                <div class="marker" data-lat="<?= $companyLocation['lat']; ?>"
                     data-lng="<?= $companyLocation['lng']; ?>">
                </div>
            </div>
        </div>
    </div>
</div>
