import 'egalink-toasty.js';
import 'egalink-toasty.js/dist/toasty.min.css';

const toast = new Toasty();// eslint-disable-line
let productOption = '';
let productThumb = '';
let variation = '';


$('body').on('click', '.product-box', function() {
    productOption = $(this).attr('data-option');
    productThumb = $(this).attr('data-product-thumb');
    variation = $(this).attr('data-variation-id');

    $('.modal-option img').attr('src', productThumb);// eslint-disable-line
    $('.modal-option span').html(productOption);

    $('.more-colors').attr('data-product-id', productOption);
    $('.more-colors').attr('data-option', productOption);

    $('[name="variation_id"]').val(variation);
    $('#variation-modal').modal('hide');
});

$('body').on('change', '.default-select', function() {
    const newVariationId = $(this).val();
    $('.variation_id').val(newVariationId);
});



$('body').on('click', '.product_type_variable', function() {
    const productId = $('[name="product_id"]').val();
    const variationId = $('[name="variation_id"]').val();
    const defaultSelect = $('.default-select');

    let basketCount = $('.header-cart-count').text().split('(');// eslint-disable-line
    basketCount = parseInt(basketCount[1].split(')'));// eslint-disable-line
    const newBasket = '(' + (basketCount + 1) + ')';// eslint-disable-line

    if (variationId === '0' && !defaultSelect) {
        toast.warning('Please select a product.');
    } else {
        $.ajax({
            type: 'POST',
            url: ajaxUrl,// eslint-disable-line
            dataType: 'html',
            data: {
                action: 'customVariableAddToCart',
                productId,
                variationId,
            },
            success: () => {
                toast.success('Product has been added to the basket!');
            },
            failure: () => {
                toast.warning('Unfortunately something has gone wrong, please try to refresh the page.');
            }
        });
        $('.header-cart-count').text(newBasket);
    }
});

$('.product-box').each(function() {
    $(this).on('click', function() {
        productOption = $(this).attr('data-variation');
        productThumb = $(this).attr('data-product-thumb');
        console.log(productThumb);

        $('.modal-option img').attr('src', productThumb);// eslint-disable-line
        $('.modal-option span').html(productOption);

        $('.more-colors').attr('data-product-id', productOption);
        $('.more-colors').attr('data-option', productOption);

        $('.product-modal').modal('hide');

        if ($(this).attr('data-changeable') === '1') {
            $(this).closest()
                .addClass('prodactive');
            $('.feature__image-inner').html('<img src="' + productThumb + '" alt=""/>');// eslint-disable-line
        }

        $('.prod-width').html($(this).attr('data-width'));
        $('.prod-weight').html($(this).attr('data-weight'));
        $('.prod-pattern').html($(this).attr('data-notes'));
    });
});
