import 'egalink-toasty.js';
import 'egalink-toasty.js/dist/toasty.min.css';

const toast = new Toasty();// eslint-disable-line
const urlParams = new URLSearchParams(window.location.search);

let step;
if (!urlParams.get('step')) {
    step = 'kilts';
} else {
    step = urlParams.get('step');
}
console.log(step);

let productId = '';
let productOption = '';
let productThumb = '';
let productVariationId = '';
let productMainImage = '';
let productMainImageContainer = '';
$('.product-box').each(function() {
    $(this).on('click', function() {
        productId = $(this).attr('data-product-id');
        productVariationId = $(this).attr('data-variation-id');
        productOption = $(this).attr('data-variation');
        productThumb = $(this).attr('data-product-thumb');

        productMainImageContainer = $(this).parents('.product-wrap');
        productMainImage = productMainImageContainer.find('img').attr('src');

        $('.modal-option img').attr('src', productThumb);// eslint-disable-line
        $('.modal-option span').html(productOption);

        $('.more-colors').attr('data-product-id', productOption);
        $('.more-colors').attr('data-option', productOption);

        $('.product-modal').modal('hide');

        const currentStep = $('.product-builder-row').attr('data-currentstep');
        $('article.product').removeClass('active');
        $(this).closest()
            .addClass('prodactive');

        if (step === 'kilts' || step === 'ties' || step === 'flashes') {
            $(`.product-builder-row > div > a[href="?step=${currentStep}"]`).html(`<img src='${productMainImage}' alt=''/><img class="thumbnail" src='${productThumb}' alt=''/>`);
        } else {
            $(`.product-builder-row > div > a[href="?step=${currentStep}"]`).html(`<img src='${productThumb}' alt=''/>`);
        }
    });
});

$('.product-wrap>img, .product-wrap>h3').on('click', function() {
    const el = $(this).parent()
        .find('.more-colors');
    el.trigger('click');
});

$('.product-modal').on('hidden.bs.modal', function() {
    console.log(productVariationId);
    $.ajax({
        type: 'POST',
        url: ajaxUrl,// eslint-disable-line
        dataType: 'html',
        data: {
            action: 'buildSteps',
            productId,
            productVariationId,
            productOption,
            step,
            productMainImage,
            productThumb
        },
    });
});

$('.copy-link').on('click', () => {
    const copyText = document.getElementById('product-link');
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    document.execCommand('copy');
    toast.success('You have copied your link!');
});
