<?php
global $post;

$crosssellProductIds = get_post_meta(get_the_ID(), '_crosssell_ids');
$crosssellProductIds = $crosssellProductIds[0];

if (!$crosssellProductIds) {
    $terms = get_the_terms($post->ID, 'product_cat');
    $crosssellProductIds = get_field('global_crossell_products','product_cat_' . $terms[0]->term_id);
}

if ($crosssellProductIds) { ?>
    <section class="intro container text-center">
        <div class="intro__content col-12" data-aos="zoom-out" data-aos-anchor-placement="top-bottom">
            <h2>View more</h2>
        </div>
    </section>

    <section class="product-list wrap-large">
        <div class="row justify-content-center">
            <?php foreach ($crosssellProductIds as $crosssell) { ?>
                <?php $post_object = wc_get_product($crosssell);
                setup_postdata($crosssell);
                ?>
                <article <?php post_class(); ?>>
                    <a class="product-wrap d-flex flex-column" href="<?= get_the_permalink($crosssell) ?>">
                        <?php do_action('woocommerce_before_shop_loop_item_title'); ?>
                        <h3><?= get_the_title($crosssell); ?></h3>
                        <div class="more-colors">+More options</div>
                    </a>
                </article>
            <?php } ?>
        </div>
    </section>
<?php }

