<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

get_header('shop');

/**
 * ALTERED HOOK
 * woocommerce_before_main_content hook.
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action('woocommerce_before_main_content');

global $wp_query;

$cat = $wp_query->get_queried_object();
$title = $cat->name;
$description = $cat->description;

$banner_id = get_woocommerce_term_meta($cat->term_id, 'thumbnail_id', true);

$bannerImage = get_field('shop_header_image', 'option');
$bannerImage = wp_get_attachment_url($bannerImage);

$globalOffsetLink = get_field("global_offset_link", $cat);

?>
<div class="product-page product-collection">
    <section class="feature offset-section" style="background-image: url('<?= $bannerImage; ?>')">
        <div class="wrap-large">
            <?php
            $featuredImage = get_field('feature_block_background_image', 'option');
            $featuredImage = wp_get_attachment_url($featuredImage);
    
            $title = get_field('feature_block_title', 'option');
            $content = get_field('feature_block_content', 'option');
            ?>
            <div class="offset-feature" style="background-image:url('<?= $featuredImage; ?>')">
                <div class="content-wrap">
                    <h1><?= $title; ?></h1>
                    <p><?= $content; ?></p>
                    <?php if ($globalOffsetLink) { ?>
                        <a class="btn btn-primary" href="<?= $globalOffsetLink['url']; ?>"
                           target="<?= $globalOffsetLink['target']; ?>"><?= $globalOffsetLink['title'] ?></a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>

    <?php get_template_part('woocommerce/parts/filter');

    if (have_posts()) {
        get_template_part('woocommerce/parts/product-list');
    } else if (!woocommerce_product_subcategories(['before' => woocommerce_product_loop_start(false), 'after' => woocommerce_product_loop_end(false)])) {
        /**
         * woocommerce_no_products_found hook.
         *
         * @hooked wc_no_products_found - 10
         */
        do_action('woocommerce_no_products_found');
    } ?>
</div>
<?php get_footer('shop'); ?>
