<?php
$collections = \Blue2\scruffy\Utils::collectionSearch();
$center = (!have_posts()  && !count($collections)) ? 'text-center' : '';
?>

<div class="single-page padding-wrap search-page">
    <section class="single-page__content content-padding--2">
        <div class="container <?= $center ?>">
            <div class="row">
                <div class="col-12">
                    <h1>Search results, <?= get_search_query(); ?></h1>
                </div>
                <div class="col-12">
                    <form action="<?= home_url('/') ?>">
                        <div class="form-group">
                            <input type="text" class="form-control" name="s" placeholder="Search...">
                            <input type="submit" value="search" class="btn btn-primary">
                        </div>
                    </form>
                </div>
            </div>
            <div class="results <?= $center ?>">
            <?php              
            foreach($collections as $collection){ ?>
                <article>
                    <a href="<?=get_term_link($collection);?>">
                        <h2><?=$collection->name;?> - Collection</h2>
                    </a>
                </article>
            <?php } ?>

            <?php \Blue2\Scruffy\Utils::searchLoop(count($collections)); ?>
            </div>
            <?php the_posts_navigation([
                'next_text' => __('Previous', 'textdomain'),
                'prev_text' => __('Next', 'textdomain')
            ]) ?>
        </div>
    </section>
</div>
