<?php

use Roots\Sage\Setup;
use Roots\Sage\Wrapper;

?>

<!doctype html>
<html <?php language_attributes(); ?> class="wf-loading">
  <?php get_template_part('templates/head'); ?>
  <body <?php body_class(); ?>>

    <?php if(is_front_page()) : ?>
        <div class="loading-msg">
            <div class="text-center msg">
                <img class="img-responsive" src="<?php echo get_stylesheet_directory_uri() . '/dist/images/logo.png'?>" alt="" /><br/>
                <span class="fa fa-spin fa-circle-o-notch"></span>
            </div>
        </div>
    <?php endif ?>
  
    <!--[if IE]>
      <div class="alert alert-warning">
        <?php _e('You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.', 'sage'); ?>
      </div>
    <![endif]-->
    <?php
      do_action('get_header');
      get_template_part('templates/header');
    ?>
	<div class="allContentWrap">
    <div class="wrap" role="document">
		<main class="main">
          <?php include Wrapper\template_path(); ?>
        </main><!-- /.main -->
    </div><!-- /.wrap -->
    <?php
      do_action('get_footer');
      get_template_part('templates/footer');
      wp_footer();
    ?>
	
	
	
	
    <script type="text/javascript">//<![CDATA[
      cookieControl({
          t: {
              title: '<p>This site uses cookies to store information on your computer.</p>',
              intro: '<p>Some of these cookies are essential to make our site work and others help us to improve by giving us some insight into how the site is being used.</p>',
              full:'<p>These cookies are set when you submit a form, login or interact with the site by doing something that goes beyond clicking some simple links.</p><p>We also use some non-essential cookies to anonymously track visitors or enhance your experience of this site. If you\'re not happy with this, we won\'t set these cookies but some nice features on the site may be unavailable.</p><p>To control third party cookies, you can also <a class="ccc-settings" href="browser-settings" target="_blank">adjust your browser settings.</a></p><p>By using our site you accept the terms of our <a href="http://gneissenergy.com/privacy-policy/">Privacy Policy</a>.</p>'
          },
          position:CookieControl.POS_LEFT,
          style:CookieControl.STYLE_TRIANGLE,
          theme:CookieControl.THEME_LIGHT, // light or dark
          startOpen:true,
          autoHide:7000,
          subdomains:true,
          protectedCookies: [], // list the cookies you do not want deleted, for example ['analytics', 'twitter']
          apiKey: '0b6eaa373113b883c73b7d30aaf3d69530e3ec85',
          product: CookieControl.PROD_FREE,
          consentModel: CookieControl.MODEL_INFO,
          onAccept:function(){ccAddAnalytics()},
          onReady:function(){},
          onCookiesAllowed:function(){ccAddAnalytics()},
          onCookiesNotAllowed:function(){}
          });
    
          function ccAddAnalytics() {
            jQuery.getScript("http://www.google-analytics.com/ga.js", function() {
              var GATracker = _gat._createTracker('UA-87427443-1');
              GATracker._trackPageview();
            });
          }
       //]]>
    </script>
    
  </body>
</html>
