<?php
	/**
		* Template Name: Tabbed content
	*/
?>
<?php if (get_field('page_header')) { ?>
	<?php 
    	global $post; 
        $bannerVar =  $post->post_name;
              
    	if (is_page( 'market-update' )) { 
        	$bannerVar = 'marketUpdate'; 
        }elseif (is_page( 'careers' )) {
             $bannerVar = 'careers'; 
        } elseif (is_page( 'media-centre' )) { 
            $bannerVar = 'mediaCentre'; 
        } elseif (is_page( 'investments' )) { 
            $bannerVar = 'investments'; 
        } 
    ?>
	<div class="bannerWrap internalWrap <?php echo $bannerVar; ?>">
		<div class="container">
			<div class="row">
				<div class="col-xs-12">
					<div class="strapline">
						<?php $block = get_field('page_header');
							$wordarray = explode(' ', $block); 
							if (count($wordarray) > 1 ) { 
								$wordarray[count($wordarray)-1] = '<span>'.($wordarray[count($wordarray)-1]).'</span>'; 
								$block = implode(' ', $wordarray);  
							}
						?>
						<h2><?php echo $block; ?></h2>
					</div>
				</div>
			</div>
		</div>
	</div>	
<?php } else { } ?>
<div class="sectionWrap">
	<div class="container">
		<div class="row">
			<div class="col-xs-12">
				<?php while (have_posts()) : the_post(); ?>
				<?php
					if (is_page( 'media-centre' )) {
						// No Header Needed
					} else {
						get_template_part('templates/page', 'header'); 
					}
				?>
				<?php get_template_part('templates/content', 'page'); ?>
				<?php endwhile; ?>
			</div>
		</div>
		<div class="row">
    		<div class="tabbed-content-nav">
    		    <nav class="tab-nav">
    		        <ul class="nav nav-tabs">
    		        <?php
    		            if( have_rows('tabs') ){
    		            $i=0;
        		            while ( have_rows('tabs') ) : the_row();
        		                $i++;
        		                if($i==1){
            		                $in='active';
        		                }else{
            		                $in='';
        		                }
        		                $tabHeading = get_sub_field('tab_heading');
        		                $tabId = preg_replace("![^a-z0-9]+!i", "-", $tabHeading);
        		                echo '<li class="'.$in.'"><a href="#'.$tabId.'_tab'.$i.'">'.$tabHeading.'</a></li>';
                            endwhile;
                        }
                    ?>
    		        </ul>
    		    </nav>
    		</div>
    		<div class="tabbed-content-row tab-content">
				    <?php

                    // check if the repeater field has rows of data
                    if( have_rows('tabs') ){
                        $i=0;
                        while ( have_rows('tabs') ) : the_row();
                                $i++;
                                $tabHeading = get_sub_field('tab_heading');
        		                $tabId = preg_replace("![^a-z0-9]+!i", "-", $tabHeading);
        		                if($i==1){
            		                $in=' in active';
        		                }else{
            		                $in='';
        		                }
                            ?>
                            <div role="tabpanel" class="tab-content-item tab-pane fade<?php echo $in;?>" id="<?php echo $tabId.'_tab'.$i;?>">
                                <?php
                                // display a sub field value
                                echo '<h2 class="col-xs-12">'.$tabHeading.'</h2>';
                                ?>
                                <div class="col-sm-7">
                                    <?php
                                    the_sub_field('tab_content');
                                    
                                    ?>
                                    
                                </div>
                                <div class="col-sm-5">
                                    <?php 
                    				    if(get_sub_field('icon')){
                        				    $templateDir =  get_template_directory_uri();
                        				    $iconPath=$templateDir."/dist/images/icons/".get_sub_field('icon');
                        				    $context = stream_context_create(array('http' => array('header'=>'Connection: close\r\n')));
                    					    echo '<div class="icon icon-tabs">'.file_get_contents($iconPath,false,$context).'</div>'; 
                                        }
                    				?>
                                    
                                    <?php
                                    // CTA & img.
                                    $image = get_sub_field('tab_image');
                                    if( !empty($image) ): ?>
                                    	<img class="img-responsive center-block" src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" />
                                    <?php endif;
                                    the_sub_field('tab_cta_text');
                                
            						if (get_sub_field('link') && get_sub_field('button_text')){?>
        							    <a class="btn btn-cta" href="<?php the_sub_field('link');?>"><?php the_sub_field('button_text');?></a>
        							<?php
        							}
                                    ?>
                                </div>
                                <?php
                		            if( have_rows('sub_tabs') ){
                                ?>
                                <div class="sub_tabbed-content-nav">
                            		    <nav class="tab-nav">
                            		        <ul class="nav nav-tabs">
                                		        <?php
                                		            $ii=0;
                                		             while ( have_rows('sub_tabs') ) : the_row();
                                		                $ii++;
                                		                if($ii==1){
                                    		                $subIn='active';
                                		                }else{
                                    		                $subIn='';
                                		                }
                                		                $subTabHeading = get_sub_field('sub_tab_heading');
                                		                $subTabId = preg_replace("![^a-z0-9]+!i", "-", $subTabHeading);
                                		                echo '<li class="'.$subIn.'"><a href="#'.$subTabId.'_subTab'.$ii.'"><span class="circled">'.$ii.'</span> <span class="tab-heading">'.$subTabHeading.'</span></a></li>';
                                                endwhile;
                                            
                                            
                                            ?>
                            		        </ul>
                            		    </nav>
                            		</div>
                                    <?php
                                        }
                                            
                                    ?>
                                    
                                    <?php                
                                        // check if the repeater field has rows of data
                                        if( have_rows('sub_tabs') ){
                                    ?>
                                    <div class="sub_tabbed-content-row tab-content">
                				    <?php
                                        $ii=0;
                                        while ( have_rows('sub_tabs') ) : the_row();
                                                $ii++;
                                                $subTabHeading = get_sub_field('sub_tab_heading');
                        		                $subTabId = preg_replace("![^a-z0-9]+!i", "-", $subTabHeading);
                        		                if($ii==1){
                            		                $subIn=' in active';
                        		                }else{
                            		                $subIn='';
                        		                }
                                            ?>
                                            <div role="tabpanel" class="tab-content-item tab-pane fade<?php echo $subIn;?>" id="<?php echo $subTabId.'_subTab'.$ii;?>">
                                                <?php
                                                // display a sub field value
                                                echo '<h2 class="col-xs-12">'.$subTabHeading.'</h2>';
                                                ?>
                                                <div class="col-sm-12">
                                                    <?php
                                                    the_sub_field('sub_tab_content');
                                                    
                                                    ?>
                                                </div>
                                            </div>
                                        <?php
                                        endwhile;
                                   ?>
                                    </div>
                                <?php
                                     }
                                ?>
                            </div>
                    <?php
                        endwhile;
                    
                    }
                    
                    ?>
				</div>
		</div>
	</div>
</div>
<?php 
	if (have_rows('content_section')) {
	?>
	<div class="repeatyWrap">
		<?php while (have_rows('content_section')) {
			the_row();
			$remove[] = " ";
			$remove[] = "'";
			$remove[] = '"';
			$remove[] = "-";
			$remove[] = "&";
			$remove[] = "#038;";
			$themTitles = get_sub_field('section_title');
		?>
		<div class="sectionWrap" id="<?php echo str_replace($remove,"", $themTitles); ?>">
			<div class="container">
				<div class="row">
					<div class="col-xs-12">
						<h2> <?php the_sub_field('section_title'); ?> </h2>
					</div>
					<div class="col-xs-12 col-md-8"> <?php the_sub_field('additional_content_left_one'); ?> </div>
					<div class="col-xs-12 col-md-4"> <?php the_sub_field('additional_content_right_one'); ?> </div>
				</div>
				
			</div>
		</div>
		<?php } ?>
	</div>
<?php } ?>				