<?php
	/**
		* Template Name: Services Page
	*/
?>
<?php if (get_field('page_header')) { ?>
	<div class="bannerWrap internalWrap services">
		<div class="container">
			<div class="row">
				<div class="col-xs-12">
					<div class="strapline">
						<?php $block = get_field('page_header');
							$wordarray = explode(' ', $block); 
							if (count($wordarray) > 1 ) { 
								$wordarray[count($wordarray)-1] = '<span>'.($wordarray[count($wordarray)-1]).'</span>'; 
								$block = implode(' ', $wordarray);  
							}
						?>
						<h2><?php echo $block; ?></h2>
					</div>
				</div>
			</div>
		</div>
	</div>	
<?php } else { } ?>
<div class="sectionWrap">
	<section class="container">
		<div class="row">
			<div class="col-xs-12">
				<?php while (have_posts()) : the_post(); ?>
				<?php get_template_part('templates/page', 'header'); ?>
				<?php get_template_part('templates/content', 'page'); ?>
				<?php endwhile; ?>
			</div>
		</div>
	</section>

<?php
	if (have_rows('content_section_one')) {
	?>
	
		<section class="container">
			<div class="row">
				<div class="col-xs-12">
					<?php while (have_rows('content_section_one')) {
						the_row();
					?>
						<h1><?php the_sub_field('section_title'); ?></h1>
						<div class="row">
							<div class="col-sm-8">
								<?php the_sub_field('additional_content_left_one'); ?>
							</div>
							<div class="col-sm-4">
								<?php the_sub_field('additional_content_right_one'); ?>
							</div>
						</div>
					<?php } ?>
				</div>
			</div>
		</section>
	
<?php } ?>	
</div>	
<?php 
	if (have_rows('content_section')) {
	?>
	<div class="repeatyWrap service-panel">
    	<h2 class="text-center">What we do</h2>
    	<span class="titleBlk"></span>
		<div class="sectionWrap serviceWrap">
			<div class="container-fluid">
				<div class="row">
    				<div class="servicesRow">
    					<?php 
    						$count = 0;
    						while (have_rows('content_section')) {
    						the_row();
    						$remove[] = " ";
    						$remove[] = "'";
    						$remove[] = '"';
    						$remove[] = "-";
    						$remove[] = "&";
    						$remove[] = "#038;";
    						$remove[] = "?";
    						$themTitles = get_sub_field('section_title');
    					?>
    					<div class="col-xs-12 col-lg-4 servicesPan image<?php echo $count; ?> text-center" id="<?php echo str_replace($remove,"", $themTitles); ?>">
        					<?php 
            				    if(get_sub_field('section_icon')){
                				    $templateDir =  get_template_directory_uri();
                				    $iconPath=$templateDir."/dist/images/icons/".get_sub_field('section_icon');
            					   // echo '<div class="icon icon-servicesPanel">'.file_get_contents(get_template_directory_uri()."/dist/images/icons/".get_sub_field('section_icon')).'</div>'; 
            					    $context = stream_context_create(array('http' => array('header'=>'Connection: close\r\n')));
                                    echo '<div class="icon icon-servicesPanel">'.file_get_contents($iconPath,false,$context).'</div>';
                                }
            				?>
    						<h2> <?php the_sub_field('section_title'); ?> </h2>
    						<?php the_sub_field('additional_content'); ?>
    						<?php
        						if (get_sub_field('link') && get_sub_field('button_text')){?>
    							    <a class="btn btn-cta" href="<?php the_sub_field('link');?>"><?php the_sub_field('button_text');?></a>
    							<?php
    							}
    				            ?>
    
    					</div>
    					<?php $count++; }  ?>
    				</div>
				</div>
			</div>
		</div>
	</div>
<?php } ?>				
<?php //get_template_part('templates/our-clients'); ?>
<?php //get_template_part('templates/advisors'); ?>