<?php
	/**
		* Template Name: Multi-column layout
	*/
?>
<?php if (get_field('page_header')) { ?>
	<?php if (is_page( 'market-update' )) { $bannerVar = 'marketUpdate'; } elseif (is_page( 'careers' )) { $bannerVar = 'careers'; } elseif (is_page( 'media-centre' )) { $bannerVar = 'mediaCentre'; } elseif (is_page( 'investments' )) { $bannerVar = 'investments'; } else { $bannerVar = ''; } ?>
	<div class="bannerWrap internalWrap <?php echo $bannerVar; ?>">
		<div class="container">
			<div class="row">
				<div class="col-xs-12">
					<div class="strapline">
						<?php $block = get_field('page_header');
							$wordarray = explode(' ', $block); 
							if (count($wordarray) > 1 ) { 
								$wordarray[count($wordarray)-1] = '<span>'.($wordarray[count($wordarray)-1]).'</span>'; 
								$block = implode(' ', $wordarray);  
							}
						?>
						<h2><?php echo $block; ?></h2>
					</div>
				</div>
			</div>
		</div>
	</div>	
<?php } else { } ?>
<div class="sectionWrap">
	<div class="container">
		<div class="row">
			<div class="col-xs-12">
				<?php while (have_posts()) : the_post(); ?>
				<?php
					if (is_page( 'media-centre' )) {
						// No Header Needed
					} else {
						get_template_part('templates/page', 'header'); 
					}
				?>
				<?php get_template_part('templates/content', 'page'); ?>
				<?php endwhile; ?>
			</div>
		</div>
		<div class="row">
    		<div class="multi-column-row">
				    <?php

                    // check if the repeater field has rows of data
                    if( have_rows('columns') ):
                    
                        // Work out bootstrap cols to use.
                        $rowCount = count(get_field('columns'));
                        $colCount=ceil(12/$rowCount);
                        if($colCount<3){
                            $midBreak='col-md-'.$colCount*2;
                            $bigBreak='';
                        }elseif($colCount<4){
                            $midBreak='col-md-'.$colCount*2;
                            $bigBreak=' col-lg-'.$colCount;
                        }else{
                            $midBreak='col-md-'.$colCount;
                            $bigBreak='';
                        }
                     	// loop through the rows of data
                        while ( have_rows('columns') ) : the_row();
                            ?>
                            <div class="multi-column-item col-sm-6 <?php echo $midBreak.$bigBreak;?>">
                            <?php
                            // display a sub field value
                            echo '<h2>'.get_sub_field('column_heading').'</h2>';
                            the_sub_field('column_content');
                            ?>
                            </div>
                    <?php
                        endwhile;
                    
                    else :
                    
                        // no rows found
                    
                    endif;
                    
                    ?>
				</div>
		</div>
	</div>
</div>
<?php 
	if (have_rows('content_section')) {
	?>
	<div class="repeatyWrap">
		<?php while (have_rows('content_section')) {
			the_row();
			$remove[] = " ";
			$remove[] = "'";
			$remove[] = '"';
			$remove[] = "-";
			$remove[] = "&";
			$remove[] = "#038;";
			$themTitles = get_sub_field('section_title');
		?>
		<div class="sectionWrap" id="<?php echo str_replace($remove,"", $themTitles); ?>">
			<div class="container">
				<div class="row">
					<div class="col-xs-12">
						<h2> <?php the_sub_field('section_title'); ?> </h2>
					</div>
					<div class="col-xs-12 col-md-8"> <?php the_sub_field('additional_content_left_one'); ?> </div>
					<div class="col-xs-12 col-md-4"> <?php the_sub_field('additional_content_right_one'); ?> </div>
				</div>
				
			</div>
		</div>
		<?php } ?>
	</div>
<?php } ?>				