<?php
	/**
		* Template Name: Market Update Page
	*/
?>
<?php if (get_field('page_header')) { ?>
	<?php 
    	global $post; 
        $bannerVar =  $post->post_name;
              
    	if (is_page( 'market-update' )) { 
        	$bannerVar = 'marketUpdate'; 
        }elseif (is_page( 'careers' )) {
             $bannerVar = 'careers'; 
        } elseif (is_page( 'media-centre' )) { 
            $bannerVar = 'mediaCentre'; 
        } elseif (is_page( 'investments' )) { 
            $bannerVar = 'investments'; 
        } 
    ?>
	<div class="bannerWrap internalWrap <?php echo $bannerVar; ?>">
		<div class="container">
			<div class="row">
				<div class="col-xs-12">
					<div class="strapline">
						<?php $block = get_field('page_header');
							$wordarray = explode(' ', $block); 
							if (count($wordarray) > 1 ) { 
								$wordarray[count($wordarray)-1] = '<span>'.($wordarray[count($wordarray)-1]).'</span>'; 
								$block = implode(' ', $wordarray);  
							}
						?>
						<h2><?php echo $block; ?></h2>
					</div>
				</div>
			</div>
		</div>
	</div>	
<?php } else { } ?>
 <div class="sectionWrap">
	<div class="container">
		<div class="row">		
			<div class="col-xs-12">
    			<?php get_template_part('templates/page', 'header'); ?>
                <div class="tabbed-content-nav">
                    <nav class="tab-nav">
                        <ul class="nav nav-tabs">
                	        <li class="active"><a href="#tab_gneissPress">Gneiss Energy in the press</a></li>
                	        <li><a href="#tab_market">Quarterly commodity price outlook</a></li>
                        </ul>
                	</nav>
                </div>
            </div>
		</div>
	
<div class="tabbed-content-row tab-content">
    <div role="tabpanel" class="pressTab tab-content-item tab-pane fade in active" id="tab_gneissPress">
        	
		<div class="row">		
			<div class="col-xs-12">
    			<?php 
        			// Get posts from Press cateogry.
        			query_posts('category_name=gneiss-energy-in-the-press&posts_per_page=15'); 
        			echo '<h2>Gneiss Energy in the press</h2>';
        			if ( have_posts() ) : while ( have_posts() ) : the_post();  
        		    ?>
        		    <div class="row">
            		    <div class="col-sm-7">
                		    <?php	
                            echo '<h3>';
                            the_title(); 
            			    echo '</h3>';
            			    the_content(); 
            			    if (get_field('article_link')){
                			    ?>
                			    <a href="<?php echo get_field('article_link');?>" target="_blank"><?php echo get_field('link_text'); ?> ▸</a>
                			    <?php
            			    }
            			    ?>
            		    </div>
            		    <div class="col-sm-5">
                		    <?php 
                                if ( has_post_thumbnail() ) {
                                	the_post_thumbnail("large", array('class' => 'img-responsive center-block'));
                                } 
                            ?>
            		    </div>
        		    </div>
                   <hr>
                <?php 
                    endwhile; 
                    endif;  
                    wp_reset_query(); 
                ?>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<?php while (have_posts()) : the_post(); ?>
				<?php get_template_part('templates/content', 'page'); ?>
				<?php endwhile; ?>
				<br />
			</div>
		</div>
        	
    </div>

    <div role="tabpanel" class="tab-content-item tab-pane fade" id="tab_market">
    <?php 
    	if (have_rows('content_section')) {
    	?>
    	<div class="repeatyWrap">
    		<?php while (have_rows('content_section')) {
    			the_row();
    			$remove[] = " ";
    			$remove[] = "'";
    			$remove[] = '"';
    			$remove[] = "-";
    			$remove[] = "&";
    			$remove[] = "#038;";
    			$themTitles = get_sub_field('section_title');
    		?>    			
				<div class="row" id="<?php echo str_replace($remove,"", $themTitles); ?>">
					<div class="col-xs-12">
						<h2> <?php the_sub_field('section_title'); ?> </h2>
					</div>
					<div class="col-xs-12 text-center"> <?php the_sub_field('additional_content_right_one'); ?> </div>
					<div class="col-xs-12"> <?php the_sub_field('additional_content_left_one'); ?> </div>
				</div>	
    		<?php } ?>
    	</div>
    <?php } ?>				
    </div>
</div>