/* ========================================================================
	* DOM-based Routing
	* Based on http://goo.gl/EUTi53 by Paul Irish
	*
	* Only fires on body classes that match. If a body class contains a dash,
	* replace the dash with an underscore when adding it to the object below.
	*
	* .noConflict()
	* The routing is enclosed within an anonymous function so that you can
	* always reference jQuery with $, even when in .noConflict() mode.
* ======================================================================== */

(function($) {
	
	// Use this variable to set up the common and page specific functions. If you
	// rename this variable, you will also need to rename the namespace below.
	
	// Breakpoints to match Bootstrap.
   var screenSmMin=768,
       screenMdMin=990,
       screenLgMin=1200,
       screenXlMin=1500;
       
	var Sage = {
		// All pages
		'common': {
			init: function() {
				// JavaScript to be fired on all pages
				
				playBgVids = function(){
                    if($('body').width()>screenSmMin - 1){
                        $('video.bgvid').each(function(i){
                            $(this).get(0).play();
                        });
                    }else{
                        // $('.playToggle').removeClass('fa-pause').addClass('fa-play');
                    }
                };
                playBgVids();
            
				
				$('ul.nav-tabs a').click(function (e) {
                  e.preventDefault();
                  $(this).tab('show');
                });
				
				
				// store the slider in a local variable
				var $window = $(window),
				flexslider = { vars:{} };
				
				// tiny helper function to add breakpoints
				function getGridSize() {
					return (window.innerWidth < 600) ? 1 :
					(window.innerWidth < 900) ? 4 : 5;
				}
				
				function getGridSize2() {
					return (window.innerWidth < 600) ? 1 :
					(window.innerWidth < 900) ? 4 : 6;
				}
				
				/* $(function() {
					SyntaxHighlighter.all();
				}); */
				
				$('.clientImgs').flexslider({
					animation: "slide",
					animationLoop: true,
					directionNav: true, 
					controlNav: false,
					touch: true,
					itemWidth: 210,
					itemMargin: 15,
					minItems: getGridSize2(),
					maxItems: getGridSize2()
				});
				
				$('.clientImgstwo').flexslider({
					animation: "slide",
					animationLoop: true,
					directionNav: true, 
					controlNav: false,
					touch: true,
					itemWidth: 210,
					itemMargin: 15,
					minItems: getGridSize(),
					maxItems: getGridSize()
				});
				
				$window.resize(function() {
					var gridSize = getGridSize();
					flexslider.vars.minItems = gridSize;
					flexslider.vars.maxItems = gridSize;
					
					var gridSize2 = getGridSize2();
					flexslider.vars.minItems = gridSize2;
					flexslider.vars.maxItems = gridSize2;
				});
				
				// FlexSlider 
				// Updated for homepage banner.
				var mySlideShowSpeed = $('.primary-slide .animated-slide').length;
				//mySlideShowSpeed * 4000
				$('.flexslider').flexslider({
					slideshow: true,
					slideshowSpeed: (mySlideShowSpeed * 2750),
					pauseOnAction: true,
					pauseOnHover: false,
					animation: "fade",
					animationLoop: true,
					animationSpeed: 1500,
					directionNav: true, 
					controlNav: false,
					itemWidth: 210,
					itemMargin: 15,
					minItems: 1,
					maxItems: 1,
					touch: true,  
					useCSS: false,
					start:function(slider){
    					if($('body').width()>screenSmMin - 1){ // Don't play BG Video on mobile.
        					$('#homepageSlider .bgvid-slide').each(function(index){
            					var myVid = $(this).find('video');
            					if(index>0){
                					setTimeout(function(){
                    					myVid.attr('autoplay','autoplay').get(0).pause(); // Ensure all the other video slides are paused until we need them.
                    				},450);
            					}else{
                					setTimeout(function(){
                				    	myVid.attr('autoplay','autoplay').get(0).play(); // play 1st video slide.
                                    },450);
            					}
    					    });
					    }
					},
					before: function(slider){
    					
    					var cur_Slide=slider.slides.eq(slider.animatingTo),
                            curVid=cur_Slide.find('video');
                        
                        $('.flex-fadeOver').addClass('in');
                        $('#homepageSlider .bgvid-slide').each(function(){
                                var me=$(this);
                                var myVideo=me.find('video');
                                
                                setTimeout(function(){
                                    myVideo.addClass('hidden');
                    				myVideo.get(0).pause();
                    				myVideo.get(0).currentTime = 0;
                    				
                				},405);
                				setTimeout(function(){
                    				myVideo.removeClass('hidden');
                                },600);
                            });
                            setTimeout(function(){
                				if(typeof curVid.get(0).play()=== 'function'){
                				    curVid.get(0).play();
                				}
                            },700);
        				
                    },
                    after: function(slider){
                        $('.flex-fadeOver').removeClass('in');
                    }
				});
				
				// Pause the slider after initial animation.
/*
				setTimeout(function()
				{
				    if($('#homepageSlider').length>0){
    				    $('#homepageSlider').flexslider("pause");
    				    console.log($('#homepageSlider').data('flexslider'));
				    }
				}, (mySlideShowSpeed * 4000)+2500);
*/
				
				$('.flex-nav-next, .flex-nav-prev').on('click',function(){
    				$('#homepageSlider').flexslider("play"); // Make sure the slider keeps rotating after clicking nav arrows.
				});
				
				// Menu Goodness
				var open = false;
				var openSidebar = function(){
					$('.navbar-collapse').addClass('expand');
					$('.navbar').addClass('showmenu');
					open = true;
				};
				var closeSidebar = function(){
					$('.navbar-collapse').removeClass('expand');
					$('.navbar').removeClass('showmenu');
					open = false;
				};
				$('.menuMaster').click( function(event) {
					event.stopPropagation();
					var toggle = open ? closeSidebar : openSidebar;
					toggle();
				});
				$(document).click( function(event){
					if ( !$(event.target).closest('.navbar-collapse').length ) {
						closeSidebar();   
					}
					if ( !$(event.target).closest('.navbar').length ) {
						closeSidebar();   
					}
				});
				
				var openM = false;
				var openMenu = function(){
					$('.menuMaster > div').addClass('open');
					openM = true;
				};
				var closeMenu = function(){
					$('.menuMaster > div').removeClass('open');
					openM = false;
				};
				$('.menuMaster').click( function(event) {
					event.stopPropagation();
					var toggle = openM ? closeMenu : openMenu;
					toggle();
				});
				$(document).click( function(event){
					if ( !$(event.target).closest('.menuMaster > div').length ) {
						closeMenu();   
					}
				});

				$(window).scroll(function(){

					if ($(window).width() > 768) {

						if ($(this).scrollTop() > 165) {
							$('.fixed-nav-fluid').css('display', 'block');
						} else {
							$('.fixed-nav-fluid').css('display', 'none');
						}
					}
					else{
						$('.fixed-nav-fluid').css('display', 'none');
					}
				});


			},
			finalize: function() {
				// JavaScript to be fired on all pages, after page specific JS is fired
			}
		},
		// Home page
		'home': {
			init: function() {
				// JavaScript to be fired on the home page

				/* Load Screen */
				$('#homepageSlider').flexslider("pause");
				function removeLoadingMessage() {
					$('.loading-msg .msg').delay(500).fadeOut();
					$('.loading-msg').delay(700).fadeOut();
					var primarySlide = $('#homepageSlider .primary-slide').html();
					
					setTimeout(function(){
    					$('#homepageSlider .primary-slide').html('');
    					$('#homepageSlider .slides .primary-slide').html(primarySlide);
    					$('#homepageSlider').flexslider("play");
    					}, 500);
				}
				

				// When window is loaded
				$(window).load(function() {
					removeLoadingMessage();
				});

				/* Match Height */
				$('.inner-box.split').matchHeight({
					property: 'height',
					target: null,
					remove: false
				});

			},
			finalize: function() {
				// JavaScript to be fired on the home page, after the init JS
			}
		},
		// About us page, note the change from about-us to about_us.
		'about_us': {
			init: function() {
				// JavaScript to be fired on the about us page
			}
		},
		'contact': {
			init: function() {
				// MAP ONE
				var map;
				function init() {
					var mapOptions = {
						center: new google.maps.LatLng(51.516843, -0.082708),
						zoom: 15,
						zoomControl: true,
						zoomControlOptions: {
							style: google.maps.ZoomControlStyle.DEFAULT,
						},
						disableDoubleClickZoom: true,
						mapTypeControl: true,
						mapTypeControlOptions: {
							style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
						},
						scaleControl: true,
						scrollwheel: true,
						panControl: true,
						streetViewControl: true,
						draggable : true,
						overviewMapControl: true,
						overviewMapControlOptions: {
							opened: false,
						},
						mapTypeId: google.maps.MapTypeId.ROADMAP,
						styles: [
						{
							"featureType": "water",
							"elementType": "geometry.fill",
							"stylers": [
							{ "color": "#d3d3d3" }
							]
							},{
							"featureType": "transit",
							"stylers": [
							{ "color": "#808080" },
							{ "visibility": "off" }
							]
							},{
							"featureType": "road.highway",
							"elementType": "geometry.stroke",
							"stylers": [
							{ "visibility": "on" },
							{ "color": "#b3b3b3" }
							]
							},{
							"featureType": "road.highway",
							"elementType": "geometry.fill",
							"stylers": [
							{ "color": "#ffffff" }
							]
							},{
							"featureType": "road.local",
							"elementType": "geometry.fill",
							"stylers": [
							{ "visibility": "on" },
							{ "color": "#ffffff" },
							{ "weight": 1.8 }
							]
							},{
							"featureType": "road.local",
							"elementType": "geometry.stroke",
							"stylers": [
							{ "color": "#d7d7d7" }
							]
							},{
							"featureType": "poi",
							"elementType": "geometry.fill",
							"stylers": [
							{ "visibility": "on" },
							{ "color": "#ebebeb" }
							]
							},{
							"featureType": "administrative",
							"elementType": "geometry",
							"stylers": [
							{ "color": "#a7a7a7" }
							]
							},{
							"featureType": "road.arterial",
							"elementType": "geometry.fill",
							"stylers": [
							{ "color": "#ffffff" }
							]
							},{
							"featureType": "road.arterial",
							"elementType": "geometry.fill",
							"stylers": [
							{ "color": "#ffffff" }
							]
							},{
							"featureType": "landscape",
							"elementType": "geometry.fill",
							"stylers": [
							{ "visibility": "on" },
							{ "color": "#efefef" }
							]
							},{
							"featureType": "road",
							"elementType": "labels.text.fill",
							"stylers": [
							{ "color": "#696969" }
							]
							},{
							"featureType": "administrative",
							"elementType": "labels.text.fill",
							"stylers": [
							{ "visibility": "on" },
							{ "color": "#737373" }
							]
							},{
							"featureType": "poi",
							"elementType": "labels.icon",
							"stylers": [
							{ "visibility": "off" }
							]
							},{
							"featureType": "poi",
							"elementType": "labels",
							"stylers": [
							{ "visibility": "off" }
							]
							},{
							"featureType": "road.arterial",
							"elementType": "geometry.stroke",
							"stylers": [
							{ "color": "#d6d6d6" }
							]
							},{
							"featureType": "road",
							"elementType": "labels.icon",
							"stylers": [
							{ "visibility": "off" }
							]
							},{
							"featureType": "poi",
							"elementType": "geometry.fill",
							"stylers": [
							{ "color": "#dadada" }
							]
						}
						]
					};
					var mapElement = document.getElementById('map');
					var map = new google.maps.Map(mapElement, mapOptions);
					var locations = [
					['Gneiss Energy Limited', 'undefined', 'undefined', 'undefined', 'undefined', 51.516843, -0.082708, 'https://mapbuildr.com/assets/img/markers/default.png']
					];
					function bindInfoWindow(marker, map, title, desc, telephone, email, web, link) {
						var infoWindowVisible = (function () {
							var currentlyVisible = false;
							return function (visible) {
								if (visible !== undefined) {
									currentlyVisible = visible;
								}
								return currentlyVisible;
							};
						}());
						iw = new google.maps.InfoWindow();
						google.maps.event.addListener(marker, 'click', function() {
							if (infoWindowVisible()) {
								iw.close();
								infoWindowVisible(false);
								} else {
								var html= "<div><h3>" + title + "</h3><p>Dashwood 69 Old Broad Street,<br> London, EC2M 1QS<br>+44 0203 826 4799 </p></div>";
								iw = new google.maps.InfoWindow({content:html});
								iw.open(map,marker);
								infoWindowVisible(true);
							}
						});
						google.maps.event.addListener(iw, 'closeclick', function () {
							infoWindowVisible(false);
						});
					}
					for (i = 0; i < locations.length; i++) {
						if (locations[i][1] ==='undefined'){ description ='';} else { description = locations[i][1];}
						if (locations[i][2] ==='undefined'){ telephone ='';} else { telephone = locations[i][2];}
						if (locations[i][3] ==='undefined'){ email ='';} else { email = locations[i][3];}
						if (locations[i][4] ==='undefined'){ web ='';} else { web = locations[i][4];}
						if (locations[i][7] ==='undefined'){ markericon ='';} else { markericon = locations[i][7];}
						marker = new google.maps.Marker({
							icon: markericon,
							position: new google.maps.LatLng(locations[i][5], locations[i][6]),
							map: map,
							title: locations[i][0],
							desc: description,
							tel: telephone,
							email: email,
							web: web
						});
						link = '';            
						bindInfoWindow(marker, map, locations[i][0], description, telephone, email, web, link);
					}
					google.maps.event.addListener(map, 'click', function(event){
						this.setOptions({scrollwheel:true});
					});
					google.maps.event.addListener(map, 'mouseout', function(event){
						this.setOptions({scrollwheel:false});  
					});
				} // function end
				google.maps.event.addDomListener(window, 'load', init);
			}
		}
	};
	
	// The routing fires all common scripts, followed by the page specific scripts.
	// Add additional events for more control over timing e.g. a finalize event
	var UTIL = {
		fire: function(func, funcname, args) {
			var fire;
			var namespace = Sage;
			funcname = (funcname === undefined) ? 'init' : funcname;
			fire = func !== '';
			fire = fire && namespace[func];
			fire = fire && typeof namespace[func][funcname] === 'function';
			
			if (fire) {
				namespace[func][funcname](args);
			}
		},
		loadEvents: function() {
			// Fire common init JS
			UTIL.fire('common');
			
			// Fire page-specific init JS, and then finalize JS
			$.each(document.body.className.replace(/-/g, '_').split(/\s+/), function(i, classnm) {
				UTIL.fire(classnm);
				UTIL.fire(classnm, 'finalize');
			});
			
			// Fire common finalize JS
			UTIL.fire('common', 'finalize');
		}
	};
	
	// Load Events
	$(document).ready(UTIL.loadEvents);
	
})(jQuery); // Fully reference jQuery after this point.
