<?php
$sideClass = get_sub_field("side") ?? "";
$showAdditionalContent = get_sub_field('show_additional_content');
$grahpicBG = get_sub_field('show_graphic_background');
if($showAdditionalContent){
    $lrgTxt = get_sub_field('large_text');
    $smlTxt = get_sub_field('smaller_text');
    $imgAdditional = get_sub_field('image_block');
    $lowerContent = get_sub_field('lower_row_content');
    $lowerContentBigText = get_sub_field('increase_font_size');
    $lowerImage = get_sub_field('lower_row_img');
    $lowerImageAlign = get_sub_field('image_on_right');
    $horizontalLine = get_sub_field('show_horizontal_line_graphic');
    if($sideClass!=="" && $sideClass!=="left"){
        $sideClass="order-lg-3";
        $horizontalLinePos = "hl-left";
    }else{
        $sideClass="order-lg-1";
        $horizontalLinePos = "hl-right";
    }
    if($lowerContentBigText){
        $increaseTxtSize = ' txt--lrg';
    }
}
?>

<section class="section--descriptor-panel">
    <div class="descriptor-panel" style="background-image: url('<?= get_sub_field('background_image')['url'] ?>')">
        <?php 
            if($grahpicBG){
            ?>
            <span class="graphic-device graphic-device--left rock-striation">
                <img src="<?=get_template_directory_uri();?>/dist/images/striation-graphic-float.svg" alt="graphic device">
            </span>
            <?php
                }
            ?>
        <?php
            if($showAdditionalContent){
                ?>
                <div class="col-xs-12 col-lg-6 secondary-col-panel order-lg-2">
                <?php
                    if($horizontalLine){
                ?>
                    <span class="descript-secondary-line <?=$horizontalLinePos;?>"></span>
                <?php
                }
                ?>
                <?php if($lrgTxt){
                    ?>
                    <p class="descript-secondary-lrg">
                        <?=$lrgTxt;?>
                    </p>
                    <?php
                        }
                    ?>
                    <?php if ($smlTxt){
                        ?>
                    <p class="descript-secondary-sml">
                        <?=$smlTxt;?>
                    </p>
                    <?php
                        }
                    ?>
                     <?php if ($imgAdditional){
                        ?>
                        <img src="<?=$imgAdditional['sizes']['large'];?>" alt="<?=$$imgAdditional['title'];?>"/>
                        <?php
                            }
                        ?>
                </div>
                <?php
            }
        ?>
        <div class="col-lg-6 descript-panel <?= $sideClass ?>">
            <h2><?= get_sub_field("pre_title"); ?></h2>
            <h1><?= get_sub_field("title"); ?></h1>
            <?= get_sub_field("content"); ?>

            <div class="cta-container">
                <?php if (get_sub_field("cta_1")) { ?>
                    <a href="<?= get_sub_field("cta_1"); ?>" class="descriptor_cta_1 button button--effect button--on-white"><?= get_sub_field("cta_1_text"); ?></a>
                <?php } ?>
                <?php if (get_sub_field("cta_2")) { ?>
                    <a href="<?= get_sub_field("cta_2"); ?>" class="descriptor_cta_2 button button--effect"><?= get_sub_field("cta_2_text"); ?></a>
                <?php } ?>
            </div>
        </div>
        <?php
            if($showAdditionalContent && $lowerContent){
                ?>
                <div class="descript__lower col-12 order-4">
                    <div class="descript__lower-content<?=$increaseTxtSize;?>">
                    <?=$lowerContent;?>
                    </div>
                    <?php if ($lowerImage){
                        ?>
                        <div class="descript__lower-img">
                            <img src="<?=$lowerImage['sizes']['large'];?>" alt="<?=$lowerImage['title'];?>"/>
                        </div>
                    <?php
                        }
                    ?>
                </div>
                <?php
            }
        ?>
    </div>
</section>