<?php
    $homeID = get_option('page_on_front');
    $pageID = get_the_id();
?>
<div class="single-member-cont">
    <div class="signpost">
        <a class="scrollNav" href="#Services">
            <span class="scroller"></span>
            <span class="vertical-text">VIEW FULL TEAM</span>
        </a>
    </div>
    <div class="custom-single-member">
        <div class="row">
            <div class="col-xs-12 col-md-7 custom-single-member-container">
                <div class="text-area">
                    <div class="header-section">
                        <h2><?php the_field('job_title'); ?></h2>
                        <h1><?php the_title(); ?></h1>
                    </div>
                    <div class="description">
                        <?php the_content(); ?>
                    </div>
                    <?php if (get_field('linkedin')) { ?>
                    <div class="linkedIn-btn">
                        <a class="linkedIn-link" href="<?= get_field('linkedin'); ?>"><span><i class="fab fa-linkedin-in"></i></span><?= get_field('linkedin_text'); ?></a>
                    </div>
                    <?php } ?>
                </div>
            </div>
            <div class="col-xs-12 col-md-5">
                <div class="image-section" style="background-image: url('<?= the_post_thumbnail_url(); ?>');">
                    <div class="image-section-text">
                        <?php the_excerpt(); ?>
                    </div>
                </div>
                <a href="/about/team/" class="back-to-team"><i class="fas fa-arrow-left"></i> BACK TO FULL TEAM</a>
            </div>
        </div>
    </div>
</div>

<?php
    if( have_rows('sections', $homeID )){
        while(have_rows('sections', $homeID)) {
            the_row();
            if (get_row_layout() == 'latest'){
                if (get_field('show_latest',$pageID)){
                    ?>
                    <section class="section--news-row">
                    <?php
                    get_template_part('templates/sections/latest');
                    ?>
                    </section>
                    <?php
                }
            }elseif (get_row_layout() == 'logo_tile'){
                if (get_field('show_logo_tiles',$pageID)){
                ?>
                <div class="section--logo-tile-row 5 page-<?=get_the_id();?>">
                <?php
                    get_template_part('templates/sections/logo_tile');    
                ?>
                </div>
                <?php
                }
            }
        }
    }
    
?>
<?php

$args = ['post_type' => 'team', 'posts_per_page' => 50];
$teamMembers = new WP_Query( $args );

?>
<div class="other-team-members" style="background-image: url('')">
    <div class="other-team-members-title">
        <h2>OTHER TEAM MEMBERS</h2>
    </div>
    <div class="swiper-container-other-team">
        <div class="swiper-wrapper">
            <?php
            if ( $teamMembers->have_posts() ) {
                while ( $teamMembers->have_posts() ) {
                    $teamMembers->the_post();
            ?>
                    <div class="swiper-slide">
                        <div class="team-member-block">
                            <!-- <a href="<?php the_permalink(); ?>" class="main-link"> -->
                                <div class="image-section" style="background-image: url('<?php the_post_thumbnail_url(); ?>');">
                                    <div class="content-section">
                                        <h2><?php the_title(); ?></h2>
                                        <h3><?= the_field('job_title'); ?></h3>
                                    </div>
                                </div>
                                <div class="overlay-section">
                                    <div class="mini-profile">
                                        <div class="row">
                                            <div class="col-xs-6 mini-profile-img">
                                                <img src="<?= the_post_thumbnail_url(); ?>"></img>
                                            </div>
                                            <div class="col-xs-6 name-and-job">
                                                <h2><?= the_title(); ?></h2>
                                                <h3><?= the_field('job_title'); ?></h3>
                                            </div>
                                        </div>
                                        <div class="linkedin-section">
                                            <a href="<?php the_permalink(); ?>">
                                                <div class="full-profile">
                                                    <p><span><i class="fal fa-user-alt"></i></span>View full profile</p>
                                                </div>
                                            </a>
                                            <a href="<?php the_field('linkedin') ?>" target="_blank">
                                                <div class="linkedIn">
                                                    <p><span><i class="fab fa-linkedin-in"></i></span>Connect on linkedIn</p>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <!-- </a> -->
                        </div>
                    </div>
            <?php
                }
            }
            ?>
        </div>
        <div class="swiper-button-next swiper-button-white"></div>
        <div class="swiper-button-prev swiper-button-white"></div>
    </div>
</div>

