<?php
$teamMember = get_sub_field("team_member")[0];
$teamMemberID = $teamMember->ID;
?>

<section class="section--team-profile section-50-desktop">
    <div class="team-profile">
        <div class="mini-profile">
            <div class="row">
                <div class="col-xs-5">
                    <img src="<?= get_the_post_thumbnail_url($teamMemberID); ?>"></img>
                </div>
                <div class="col-xs-7 name-and-job">
                    <h2><?= the_field('job_title',$teamMemberID); ?></h2>
                    <h3><?= $teamMember->post_title; ?></h3>
                    <div class="linkedin-section">
                        <a href="<?php the_permalink($teamMemberID); ?>">
                            <div class="full-profile">
                                <p><span><i class="fal fa-user-alt"></i></span>View full profile</p>
                            </div>
                        </a>
                        <a href="<?php the_field('linkedin',$teamMemberID) ?>" target="_blank">
                            <div class="linkedIn">
                                <p><span><i class="fab fa-linkedin-in"></i></span>Connect on linkedIn</p>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>