<?php
// $today = date('Ymd');
// $event_query = array(
//     'post_type' => 'events',
//     'post_status' => 'publish',
//     'posts_per_page' => '1',
//     'meta_key' => 'event_date',
//     'orderby' => 'meta_value',
//     'order' => 'ASC',
//     'meta_query' => array(
//         'key' => 'event_date',
//         'value' => $today,
//         'compare' => '>='
//     )
// );
$pageID = get_the_id();
$latest_event = get_sub_field("featured_event") ?? "";
$postType = get_post_type();

$news_query = array(
    'post_type' => 'post',
    'posts_per_page' => 10,
    'order' => 'DESC',
    'orderby' => 'date'
);

$latest_news = get_posts($news_query);
get_sub_field("enable_title") ? $class = "" : $class = " hidden ";
$title = get_sub_field("title"); 

$delay = 0;

$hideGradient = "";
if (is_page("latest-media")) {
    $hideGradient = " hide-gradients ";
}
?>
<section class="section--latest <?= $hideGradient ?>">
<div class="latest-gradient-top"></div>
    <div class="latest-title <?= $class ?>">
        <h2><?= $title; ?></h2>
        <a href="/news">See all</a>
    </div>
    <?php if ($latest_event !== "" && !is_page("latest-media")) : ?>
        <?php foreach ($latest_event as $key => $post) : ?>
            <?php setup_postdata($post); ?>

            <?php
            $eventImage = get_field("next_event_image",$post->ID);
            $eventDate = get_field("event_date",$post->ID);
            ?>

            <?php if (get_sub_field("featured_link",$latest_event[0]->ID)) { ?>
                <a href="<?= get_sub_field("featured_link",$latest_event[0]->ID) ?>">
            <?php } ?>
            <div class="col-md-6 col-lg-3 event-col latest-col single-event">
                <div class="latest-shadow">
                    <div class="latest-data-item">
                        <div class="event-title">
                            <h2>Next Event</h2>
                        </div>
                        <div class="image-block">
                            <?php if (!get_sub_field("featured_link",$latest_event[0]->ID)) { ?>
                                <a href="<?= the_permalink(); ?>">
                            <?php } ?>
                                    <div class="overflow-contain" style="overflow: hidden;">
                                        <?php 
                                        // the_post_thumbnail('posts-panel', array('class' => 'img-responsive'));
                                        ?> 
                                        <img class="img-responsive" src="<?= $eventImage ?>">
                                    </div>
                            <?php if (!get_sub_field("featured_link",$latest_event[0]->ID)) { ?>
                                </a>
                            <?php } ?>
                        </div>
                        <div class="custom-event-type event-type">
                            <?php 
                            the_field("event_date",$post->ID);
                            ?>
                        </div>
                        <div class="content-block">
                            <?php if (!get_sub_field("featured_link",$latest_event[0]->ID)) { ?>
                                <a href="<?= get_the_permalink(); ?>">
                            <?php } ?>
                                    <h3 class="latest-item-title"><?= the_title() ?></h3>
                            <?php if (!get_sub_field("featured_link",$latest_event[0]->ID)) { ?>
                                </a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>

            <?php if (get_sub_field("featured_link",$latest_event[0]->ID)) { ?>
                </a>
            <?php } ?>

            <?php wp_reset_postdata(); ?>
        <?php endforeach; ?>
    <?php endif; ?>
    <div class="gneiss-container swiper-container-latest">
        <div class="row row-eq-height swiper-wrapper">
            <?php foreach ($latest_news as $key => $post) : ?>
                <?php setup_postdata($post); ?>
                <?php 
                    $showPost = 1; // Don't hide any posts unless we're on a team single page.
                    if ($postType == 'team') {
                        $related_people = get_field('related_person');
                        $showPost = 0;
                        if(is_array($related_people)){
                            foreach ($related_people as $related_person){
                                //var_dump($related_person->ID);
                                if($pageID === $related_person->ID){
                                    $showPost++;
                                }
                            }
                        }
                        //var_dump($showPost);
                    }
                    
                    if($showPost>0){    
                    ?>
                <div class="col-md-6 col-lg-3 news-col latest-col swiper-slide">
                    <div class="latest-shadow" data-aos="fade-left" data-aos-delay="<?= $delay ?>">
                        <div class="latest-data-item">
                            <div class="image-block">
                                <a href="<?= the_permalink(); ?>">
                                    <div class="overflow-contain" style="overflow: hidden;">
                                        <?= the_post_thumbnail('posts-panel', array('class' => 'img-responsive')); ?>
                                    </div>
                                </a>
                            </div>
                            <div class="content-block">
                                <p class="date"><?= get_the_date('j\<\s\u\p\>S\<\/\s\u\p\> F, Y') ?></p>
                                <a href="<?= get_the_permalink() ?>">
                                    <h3 class="latest-item-title"><?= the_title() ?></h3>
                                </a>
                                <div class="custom-event-type event-type">
                                    Upcoming Event
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php $delay += 400;
                    } 
                ?>
            <?php endforeach; ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
</section>
