<?php while (have_posts()) : the_post(); ?>
    <div class="posted-on">
        <div class="posted-on-date">
            <p>Posted on: <strong><?= get_the_date(); ?></strong></p>
        </div>
        <div class="posted-on-share">
            <span>Share this page:</span>
            <div class="addthis_toolbox addthis_default_style">
                <a class="addthis_button_preferred_1"></a>
                <a class="addthis_button_preferred_2"></a>
                <a class="addthis_button_compact"></a>
            </div>
        </div>
    </div>
    <article <?php post_class(); ?>>
        <header>
            <h1 class="entry-title" style="display:<?= get_post_type() == 'post' ? "none;" : "";?>"<?php the_title(); ?></h1>
        </header>
        <div class="entry-content">
            <?php the_content(); ?>
        </div>

        <?php

        if (get_field("related_article")) {
            $relatedArticle = get_field("related_article");
            $relatedTitle = $relatedArticle[0]->post_title;
            $relatedDate = get_field("event_date", $relatedArticle[0]->ID);
            $relatedURL = get_permalink($relatedArticle[0]->ID);
            $relatedImage = get_the_post_thumbnail_url($relatedArticle[0]->ID)
        ?>

        <div class="relatedArticle">
            <div class="col-md-4 relatedImage" style="background-image: url('<?=$relatedImage?>');"></div>
            <div class="col-md-8">
                <h3>Related Article</h3>
                <p><?= $relatedDate ?></p>
                <h2><?= $relatedTitle ?></h2>
                <a href="<?= $relatedURL ?>">READ FEATURE ARTICLE</a>
            </div>
        </div>
            
        <?php
        }


        if (get_field("related_person")) {

            $relatedPerson = get_field("related_person");
            $relatedContent = $relatedPerson[0]->post_content;

        ?>
        <?php
        if( get_field('show_related_person_bio_on_article')){
        ?>
        <div class="relatedPerson">
            <p><?= $relatedContent ?></p>
        </div>
        <?php
            }
        }


            $singleType = get_post_type();

            if ($singleType == 'post'){
                $singleType = 'Article';
            } else if ($singleType == 'event') {
                $singleType = 'Event';
            } else {
                $singleType = 'Insight';
            }

            $previous = 'Previous ' . $singleType;
            $next = 'Next ' . $singleType;
        ?>
            
        <div class="posted-on posted-on-share-bottom">
            <span>Share this page:</span>
            <div class="addthis_toolbox addthis_default_style">
                <a class="addthis_button_preferred_1"></a>
                <a class="addthis_button_preferred_2"></a>
                <a class="addthis_button_compact"></a>
            </div>
            <nav class="post-nav">
                <ul class="pager">
                    <li class="previous"><?php previous_post_link('%link', $previous); ?></li>
                    <li class="next"><?php next_post_link('%link', $next); ?></li>
                </ul>
            </nav>
        </div>
    </article>
<?php endwhile; ?>
