<?php
$news_query = array(
    'post_type' => 'post',
    'posts_per_page' => '5',
    'order' => 'DESC',
    'orderby' => 'date'
);
$news = get_posts($news_query);

$events_query = array(
    'post_type' => 'events',
    'posts_per_page' => '3',
    'meta_key' => 'event_date',
    'orderby' => 'meta_value',
    'order' => 'ASC',
    'meta_query' => array(
        array(
            'key' => 'event_date',
            'value' => date('Ymd'),
            'compare' => '>='
        )
    )
);
$events = get_posts($events_query);
?>

<?php if (get_post_type() != 'post') : ?>
    <h2>Recent News</h2>
    <?php foreach ($news as $key => $post) : ?>
        <?php setup_postdata($post); ?>
        <div class="row">
            <div class="side-news">
                <div class="col-sm-6 col-md-12 col-lg-6">
                    <a href="<?= the_permalink() ?>">
                        <?= get_the_post_thumbnail($post, 'posts-panel', array('class' => 'img-responsive')); ?>
                    </a>
                </div>
                <div class="col-sm-6 col-md-12 col-lg-6">
                    <a href="<?= the_permalink() ?>"><?= the_title() ?></a>
                    <p id="date"> <?= get_the_date('jS F, Y'); ?></p>
                </div>
            </div>
        </div>
        <?php wp_reset_postdata(); ?>
    <?php endforeach; ?>
<?php endif; ?>

<?php if (get_post_type() != 'events') : ?>
    <?php if (!empty($events)) : ?>
        <h2>Upcoming Events</h2>
        <?php foreach ($events as $key => $post) : ?>
            <?php setup_postdata($post); ?>
            <div class="row">
                <div class="side-news">
                    <div class="col-sm-6 col-md-12 col-lg-6">
                        <a href="<?= the_permalink() ?>">
                            <?= get_the_post_thumbnail($post, 'posts-panel', array('class' => 'img-responsive')); ?>
                        </a>
                    </div>
                    <div class="col-sm-6 col-md-12 col-lg-6">
                        <a href="<?= the_permalink() ?>"><?= the_title() ?></a>
                        <p id="date"> <?= get_field('event_date'); ?></p>
                    </div>
                </div>
            </div>
            <?php wp_reset_postdata(); ?>
        <?php endforeach; ?>
    <?php endif; ?>
<?php endif; ?>



<?php
if (get_post_type() == 'post') : ?>
    <h2>News Archive</h2>
    <?php
    wp_get_archives('type=monthly');
    ?>
    <li><a href="<?= home_url('news') ?>">All News</a></li>
<?php endif; ?>
