<?php
$today = date('Ymd');
$event_query = array(
    'post_type' => 'events',
    'post_status' => 'publish',
    'posts_per_page' => 1,
    'meta_key' => 'event_date',
    'orderby' => 'meta_value',
    'order' => 'DESC',
);
$latest_event = get_posts($event_query);
$key_event = get_sub_field("key_event") ?? "";

if ($key_event !== "") {
    $latest_event = $key_event;
}
?>
<section class="section--key-event section-50-desktop">
<?php
if (count($latest_event) > 0) : ?>
    <?php foreach ($latest_event as $key => $post) : ?>
        <?php setup_postdata($post); ?>
        <?php if (get_sub_field("enable_title")) { ?>
            <div class="line-title">
                <?= get_sub_field("title"); ?>
            </div>
        <?php } ?>
        <?php 
            $eventImage = get_field("narrow_event_image",$post->ID) ?? "";
            if ($eventImage == "") {
                $eventImage = get_field('next_event_image',$post->ID) ?? "";
            }
            $imageActual = $nextImage ? wp_get_attachment_image_src($nextImage)[0] : get_the_post_thumbnail_url();
        ?>
        <div class="key-event-container" style="background-image: url('<?= $eventImage; ?>')">
            <a href="<?= get_the_permalink(); ?>">
                <div class="key-event-container-info">
                    <div class="col-xs-12">
                        <h2><?= the_title(); ?></h2>
                        <p><?= wp_trim_words(get_the_content(),50); ?></p>
                    </div>
                    <div class="col-sm-5 event-date">
                        <span><i class="far fa-clock"></i></span><?= the_field('event_date'); ?>
                    </div>
                    <?php
                    $eventLocation = get_field('event_location')['address'] ?? "";
                    if ($eventLocation !== "") {
                    ?>
                        <div class="col-sm-7 event-location">
                            <span><i class="fal fa-map-marker-alt"></i></span><?= $eventLocation ?>
                        </div>
                    <?php
                    }
                    ?>
                </div>
            </a>
            <?php
                $now = date('Ymd');
                $eventLabel = get_field('event_date') >= $now ? "background-color: #748693; " : "background-color: #ac9766; ";
            ?>
            <p class="key-event-container-ribbon" style="<?= $eventLabel ?>">
                <?php $ribbonBannerText = get_sub_field('ribbon_banner') ?? "Recent Event";  ?>
                <?= $ribbonBannerText ?>
            </p>
        </div>


        <?php wp_reset_postdata(); ?>
    <?php endforeach; ?>
<?php endif; ?>
    <div style="padding: 15px 0;">
        <a href="/events">
            VIEW ALL
        </a>
    </div>
</section>
