<?php
    $type = in_array('type-post', get_post_class()) ? 'news' : 'event';
    $heading_class = $type == 'news' ? '1' : '2';
?>

<article <?php post_class(); ?>>
  <div class="latest-panel">
    <div class="latest-panel__heading heading--<?=$heading_class?>">
        <?=ucfirst($type);?>
    </div>
    <a href="<?=get_the_permalink(); ?>">
        <div class="cover-image col-sm-6 latest-panel__image" data-mh="single" style="background-image: url(<?=get_the_post_thumbnail_url();?>"></div>
    </a>
    <div class="col-sm-6 latest-panel__content" data-mh="single">
        <a href="<?=get_the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
        <h4><?=the_date('jS F, Y')?></h4>
        <p><?php the_excerpt(); ?></p>
        <?php if($type == 'event') : ?><a href="<?=get_the_permalink(); ?>" class="btn-secondary">Details of event</a><?php endif; ?>
    </div>
</div>
</article>
