<?php
/**
 * Template Name: Events Archive Template
 */
?>

<?php
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$today = date('Ymd');
$query = new WP_Query(array(
    'post_type' => 'events',
    'posts_per_page' => 12,
    'meta_key' => 'event_date',
    'orderby' => 'meta_value',
    'order' => 'DESC',
    'paged' => $paged,
    'meta_query' => array(
        'key' => 'event_date',
        'value' => $today,
        'compare' => '<='
    )
));
?>

<?php if (!$query->have_posts()) : ?>
    <div class="container--small">
        <?php get_template_part('templates/page', 'header'); ?>
        <div class="alert alert-warning">
            <?php _e('Sorry, no results were found.', 'sage'); ?>
        </div>
    </div>
<?php else : ?>

    <div class="search__content events-archive-custom">
        <div class="gneiss-container">
            <div class="col-md-8">
                <div class="index-wrapper">
                    <?php while ($query->have_posts()) : $query->the_post() ?>
                        <div class="col-sm-6" data-mh="post">
                            <?php get_template_part('templates/content', 'events'); ?>
                        </div>
                    <?php endwhile; ?>
                </div>
                <div class="custom-pagination">
                    <?=
                    paginate_links([
                        'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
                        'total'        => $query->max_num_pages,
                        'current'      => max( 1, get_query_var( 'paged' ) ),
                        'format'       => '?paged=%#%',
                        'show_all'     => false,
                        'type'         => 'plain',
                        'end_size'     => 2,
                        'mid_size'     => 1,
                        'prev_next'    => true,
                        'prev_text'    => sprintf( '<i></i> %1$s', __( 'Newer Posts', 'text-domain' ) ),
                        'next_text'    => sprintf( '%1$s <i></i>', __( 'Older Posts', 'text-domain' ) ),
                        'add_args'     => false,
                        'add_fragment' => '',
                    ]);
                    ?>
                </div>
                <div class="col-xs-12 text-center">
                    <a class="btn btn-primary" href="<?= home_url('events') ?>">Upcoming Events</a>
                </div>
            </div>
            <div class="col-md-4">
                <div class="side-bar">
                    <?php get_template_part('templates/sidebar'); ?>
                </div>
            </div>
        </div>
    </div>
    <?php wp_reset_postdata(); ?>
<?php endif; ?>
