<?php
$colorClass = get_field("case_study_colour") ?? "";
$bulletColorClass = get_field("case_study_colour")."-bullets";
?>

<div class="single-service-page">
    <div class="signpost">
        <a class="scrollNav" href="#scrollTo">
            <span class="scroller"></span>
            <span class="vertical-text"><?= get_field('scroller_text') ?? "EXPLORE"; ?></span>
        </a>
    </div>
    <div class="service-page-content col-lg-6">
        <div class="service-page-content-title">
            <div class="service-page-content-title-image">
                <img class="" src="<?= get_field('icon') ?>">
            </div>
            <div class="service-page-content-title-text">
                <p class="key-service <?= $colorClass ?>">Case Study</p>
                <h2><?= the_title(); ?></h2>
            </div>
        </div>
        <div class="service-page-content-title <?= $bulletColorClass ?>">
            <?= get_field('content'); ?>
        </div>
    </div>
    <div class="single-service-page-image" style="background-image: url('<?php the_field('case_study_image'); ?>')">
    </div>
    <span class="graphic-device aos-init aos-animate rock-striation" data-aos="fade-right" data-aos-duration="3000">
        <img src="http://extranet.avian.co.uk/gneiss/2019/v3/img/striation-graphic-left.svg" alt="graphic device left">
    </span>
</div>

<?php
while (have_posts()) {
    the_post();
    if(have_rows('sections')){
        while(have_rows('sections')) {
            the_row();
            get_template_part('templates/sections/' . get_row_layout());
        }
    }
}
?>
