<section class="section--team <?= (is_page('team')) ? "team-page " : "" ?>">
    <div class="section--team-container">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane fade in active" id="core-team">
                <div class="dropdown-container">
                    <select id="categorySelector" class="categorySelector">
                        <option value="all">All</option>
                        <option value="advisors">Advisors</option>
                        <option value="leadership">Leadership</option>
                    </select>
                </div>
                <?php
                $args = ['post_type' => 'team', 'posts_per_page' => 50];
                $teamMembers = new WP_Query( $args );

                if ( $teamMembers->have_posts() ) { ?>
                    <div class="team-row">
                        <div class="team-nav">
                        </div>
                        <?php while ($teamMembers->have_posts()) {
                            $teamMembers->the_post();
                            $team_category = get_field('team_category') ?? " no-category " ;
                            ?>
                            <div class="team-col <?= $team_category ?>">
                                <div class="team-member-block">
                                    <div class="image-section" style="background-image: url('<?php the_post_thumbnail_url(); ?>');">
                                        <div class="content-section">
                                            <h2><?= the_title(); ?></h2>
                                            <h3><?= the_field('job_title'); ?></h3>
                                        </div>  
                                    </div>
                                    <div class="overlay-section">
                                        <div class="mini-profile">
                                            <div class="row">
                                                <div class="col-xs-6">
                                                    <img src="<?= the_post_thumbnail_url(); ?>"></img>
                                                </div>
                                                <div class="col-xs-6 name-and-job">
                                                    <h2><?= the_title(); ?></h2>
                                                    <h3><?= the_field('job_title'); ?></h3>
                                                </div>
                                            </div>
                                            <div class="linkedin-section">
                                                <a href="<?php the_permalink(); ?>">
                                                    <div class="full-profile">
                                                        <p><span><i class="fal fa-user-alt"></i></span>View full profile</p>
                                                    </div>
                                                </a>
                                                <a href="<?php the_field('linkedin') ?>" target="_blank">
                                                    <div class="linkedIn">
                                                        <p><span><i class="fab fa-linkedin-in"></i></span>Connect on linkedIn</p>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php }
                        wp_reset_postdata(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>