<?php
$classes = '';
$image = '';
$taglineClass = '';
get_field('large_header') ? $classes .= ' large' : $classes .=  ' small';
is_search() ? $classes = " small " : $classes .= " ";
if (get_field('tagline_type') == 'light') $classes .= ' tagline';

if (is_search()) {
    $classes .= ' search light';
    $image = "";
} elseif (is_404()) {
    $classes .= ' light error';
} elseif (is_post_type_archive('events') || get_post_type() == 'events') {
    $classes .= ' events light ';
    $taglineClass = ' light ';
} elseif (is_home()) {
    $classes .= ' events light ';
    $image = '';
} elseif (is_singular('post')) {
    $classes .= ' singular';
    $image = '';
} elseif (is_page('latest-media') || is_page('sectors')){
    $image = "";
} elseif (is_singular('team')){
    $image = "";
} elseif (is_category()){
    $image = "";
    $classes .= ' light ';
} else {
    $image = get_the_post_thumbnail_url();
}
$thisPostType = get_post_type();
$bottomBoxShadow = "";
if ($thisPostType == "service" || $thisPostType == "case-study"){
    $bottomBoxShadow = " bottom-box-shadow ";
}
if (!is_search()) {
    $thisPostTypeClass = $thisPostType . "-header-fixed";
    $classes .= " " . get_field('tagline_type');
} else {
    $thisPostTypeClass = "";
}

if (!isset($_SESSION['covid'])) {
    session_start();
} ?>

<?php if ($_SESSION['covid'] !== true && get_field('show_covid_banner', 'options')) {
    $bannerText = get_field('covid_banner_text', 'options');
    $bannerLink = get_field('covid_banner_link', 'options'); ?>
    <div class="covid-banner">
        <div>
            <?php if ($bannerLink) { ?> <a href="<?= $bannerLink; ?>" target="_blank"> <?php } ?>
                <?= $bannerText ?: 'Click here to learn more about our Covid-19 Policies'; ?>
            <?php if ($bannerLink) { ?> </a> <?php } ?>
        </div>
        <a id="covid-close" href="#">Close</a>
    </div>
<?php } ?>

<header class="banner<?= $classes . $bottomBoxShadow ?>" <?php if ($image) : ?> style="background-image: url(<?= $image ?>)"<?php endif; ?>>
    <div class="gneiss-container custom-gneiss-cont"> <!-- Start container -->
        <!-- Top bar -->
        <div class="header__content <?= $thisPostTypeClass ?>">
            <div class="row">
                <div id="brand" class="col-xs-6 col-sm-4 col-md-2">
                    <?php if (!get_field('enable_tagline') && !is_single()) : ?>
                        <h1 class="text-hide"><?php the_title(); ?></h1>
                    <?php endif; ?>
                    <a class="brand" href="<?= esc_url(home_url('/')); ?>">
                        <div class="main-logo-container"></div>
                    </a>
                </div>

                <div id="toolbar" class="col-xs-12 col-sm-8 col-md-10 pull-right">
                    <div class="header__toolbar">
                        <div class="custom-header-holder">
                            <?php
                            if (has_nav_menu('primary_navigation')) :
                                wp_nav_menu([
                                    'theme_location' => 'primary_navigation',
                                    'menu_class' => 'new-navigation',
                                ]);
                            endif;
                            ?>
                            <div class="social">
                                <?php if (have_rows('social_channels_header', 'option')) : ?>
                                    <?php while (have_rows('social_channels_header', 'option')) : the_row(); ?>
                                        <?php $platform = get_sub_field('platform'); ?>
                                        <a href="<?= get_sub_field('url') ?>" title="<?= $platform['label'] ?>"
                                           target="_blank"
                                           rel="noopener noreferrer"><i class="fab fa-lg <?= $platform['value'] ?>"></i></a>
                                    <?php endwhile; ?>
                                <?php endif; ?>
                            </div>
                            <?php get_search_form(); ?>
                            <button class="btn-toggle cbp-spmenu-push" id="nav-toggle" type="button"><i class="toggle-icon fal fa-bars fa-2x"></i></button>
                            <div style="clear:both;"></div>
                        </div>
                    </div>
                </div>

                <nav class="nav-primary active cbp-spmenu cbp-spmenu-vertical cbp-spmenu-right" id="cbp-spmenu-s2">
                    <?php
                    if (has_nav_menu('primary_navigation')) :
                        wp_nav_menu([
                            'theme_location' => 'primary_navigation',
                            'menu_class' => 'nav',
                        ]);
                    endif;
                    ?>
                </nav>

                <div class="single-post-header">
                    <p>News Room / <strong><?= is_home() ? "Archive" : get_the_title(); ?></strong></p>
                    <img src="<?= get_field("side_image_bottom"); ?>">
                </div>

            </div>
        </div>
        <div class="topBarSpacer"></div>
        <!-- End of top bar -->

        <!-- Tag line -->
        <div class="row header-banner-title">
            <?php if ((get_field('enable_tagline') && !is_search()) || is_post_type_archive('events') || get_post_type() == 'events' || is_home() || is_category()) : ?>
                <div class="tagline-panel <?= get_field('tagline_type') . $taglineClass ?>">
                    <div class="signpost">
                        <a class="scrollNav" href="#scrollTo">
                            <span class="scroller"></span>
                            <?php if (is_category("thought-leadership")) { ?>
                                <span class="vertical-text">EXPLORE</span>
                            <?php } else { ?>
                                <span class="vertical-text"><?= get_field('scroller_text') ?? "EXPLORE"; ?></span>
                            <?php } ?>
                        </a>
                    </div>
                        <?php
                        if (get_field('tagline_text')) {
                        ?>

                            <div data-aos="fade-left" data-aos-delay="1400" data-aos-duration="1500" >
                            <?= get_field('tagline_text'); ?>
                            </div>

                        <?php
                        }else{
                        ?>
                            <?php if (is_category("thought-leadership")) { ?>
                                <h1 data-aos="fade-left" data-aos-delay="1400" data-aos-duration="800">Thought Leadership</h1>
                            <?php } else if (!is_post_type_archive('events') && !is_home()){ ?>
                                <h1 data-aos="fade-left" data-aos-delay="1400" data-aos-duration="800"><?= the_title(); ?></h1>
                            <?php } else if (is_post_type_archive('events')) { ?>
                                <h1 data-aos="fade-left" data-aos-delay="1400" data-aos-duration="800">EVENTS</h1>
                            <?php } else { ?>
                                <h1 data-aos="fade-left" data-aos-delay="1400" data-aos-duration="800">NEWS ROOM</h1>
                            <?php } ?>
                        <?php
                        }
                        ?>

                        <div class="tagline-container" data-aos="fade-left" data-aos-delay="1700" data-aos-duration="1500">
                            <?= get_field('tagline_content') ?>
                        </div>

                        <?php if (get_field('enable_cta')) : ?>
                            <?php $link = get_field('tagline_cta'); ?>
                            <a class="explore-gneiss-button btn-primary button--effect"><?= $link['title'] ?></a>
                        <?php endif; ?>


                </div>
            <?php endif; ?>
        </div>
        <?php if ($thisPostType == "sector" && !is_search()) { ?>
        <div class="viewAll">
            <div class="viewAll-title">
                <h2>view <?= $thisPostType ?>:</h2>
            </div>
            <div class="viewAll-container">
                <?php if( have_rows('related_items')) { ?>
                    <?php while ( have_rows('related_items')) {
                            the_row();
                            $activeClass = "";
                            get_sub_field('active_link') ? $activeClass="active-link" : $activeClass="";
                    ?>
                            <a href="<?= get_sub_field('link'); ?>"><p class="<?= $activeClass ?>"><?= get_sub_field('item'); ?></p></a>
                    <?php } ?>
                <?php }
                ?>
            </div>
        </div>
        <?php } else if (is_page('contact'))  { ?>
            <div class="contact-details" style="display: none;">
                <div class="contact-details-title">
                    <div class="col-md-12 contact-details-box">
                        <p>Call</p>
                        <div class="footer-right-blue call"></div>
                        <div class="col-md-12 footer-text-small">
                            <i class="far fa-mobile"></i>
                            <a href="tel:+4401312253783">+44 (0) 131 225 3783</a>
                        </div>
                    </div>
                    <div class="col-md-12 contact-details-box">
                        <p>Email</p>
                        <div class="footer-right-blue email"></div>
                        <div class="col-md-12 footer-text-small">
                            <i class="fal fa-envelope"></i>
                            <a href="mailto:info@gneissenergy.com">info@gneissenergy.com</a>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
        <!-- End of Tag line -->

        <!-- Large Header Image -->
        <?php if (get_field('videos') && !get_the_post_thumbnail_url() && !is_search()) : ?>
            <?php
            $videos = get_field('videos');
            ?>

            <div class="header-cover">
                <?php if (count($videos) == 1 && isset($videos[0]['video'])) { ?>
                    <video src="<?= $videos[0]['video'] ? $videos[0]['video'] : $videos[0]['video_link']; ?>" autoplay loop></video>
                <?php } else { ?>
                    <script>
                        videos = [
                            <?php foreach($videos as $video) {
                            $image = ($video['first_frame'] != "") ? $video['first_frame']['url'] : '//via.placeholder.com/1920x1080';
                            ?>
                            [
                                "<?=$video['video_link']?>",
                                "<?=$image?>",
                            ],
                            <?php } ?>
                        ];
                    </script>
                    <style>.embed-container {
                            position: relative;
                            padding-bottom: 56.25%;
                            height: 0;
                            overflow: hidden;
                            max-width: 100%;
                        }

                        .embed-container iframe, .embed-container object, .embed-container embed {
                            position: absolute;
                            top: 0;
                            left: 0;
                            width: 100%;
                            height: 100%;
                        }</style>
                    <div class='embed-container'>
                        <iframe id="header-video" src='' frameborder='0' webkitAllowFullScreen mozallowfullscreen
                                allowFullScreen></iframe>
                    </div>
                <?php } ?>
            </div>

        <?php endif; ?>

    </div> <!-- End container -->

    <?php if ((!get_field('enable_image') && null !== get_field('videos')) || is_single() || is_search() || is_post_type_archive('events') || is_category()): ?>
        <span class="graphic-device graphic-device--right rock-striation">
            <img src="<?=get_template_directory_uri();?>/dist/images/striation-graphic-float.svg" alt="graphic device left">
        </span>
    <?php endif; ?>

    <?php if (is_home() || is_page('events')) wp_reset_postdata(); ?>
</header>
<div id="scrollTo"></div>
