<?php
$colorClass = get_field("service_colour") ?? "";
$bulletColorClass = get_field("service_colour")."-bullets";
?>

<div class="single-service-page">
    <div class="signpost">
        <a class="scrollNav" href="#scrollTo">
            <span class="scroller"></span>
            <?php if (is_category("thought-leadership")) { ?>
                <span class="vertical-text">EXPLORE</span>
            <?php } else { ?>
                <span class="vertical-text"><?= get_field('scroller_text') ?? "EXPLORE"; ?></span>
            <?php } ?>
        </a>
    </div>
    <div class="service-page-content col-lg-6">
        <div class="service-page-content-title">
            <div class="service-page-content-title-image">
                <img class="" src="<?= get_field('icon') ?>">
            </div>
            <div class="service-page-content-title-text">
                <p class="key-service <?= $colorClass ?>">Key Service</p>
                <h2><?= the_title(); ?></h2>
            </div>
        </div>
        <div class="service-page-content-title <?= $bulletColorClass ?>">
            <?= get_field('content'); ?>
        </div>
    </div>
    <div class="single-service-page-image" style="background-image: url('<?= get_field('service_image') ?>')">
    </div>
    <span class="graphic-device aos-init aos-animate rock-striation" data-aos="fade-right" data-aos-duration="3000">
        <img src="http://extranet.avian.co.uk/gneiss/2019/v3/img/striation-graphic-left.svg" alt="graphic device left">
    </span>
</div>

<?php

$relatedCaseStudy = get_field('related_case_study');
if($relatedCaseStudy){
    $caseStudyColour = get_field('case_study_colour', $relatedCaseStudy->ID); ?>
<section class="section-case-study">
    <div class="case-study-container">
        <div class="col-md-12 col-lg-8 two-fifty-three-blocks">
            <div class="related-case-study">
                <a href="<?php the_permalink($relatedCaseStudy->ID) ?>">
                    <div class="row d-flex">
                        <div class="col-sm-8 content-col">
                            <div class="content-section">
                                <h2><?= $relatedCaseStudy->post_title; ?></h2>
                                <div class="excerpt"><?php the_field('case_study_excerpt', $relatedCaseStudy->ID); ?></div>
                                <div class="cta <?= $caseStudyColour; ?>">Read More <i class="fas fa-arrow-right"></i></div>
                            </div>
                        </div>
                        <div class="col-sm-4 image-col">
                            <div class="image-section">
                                <img src="<?php the_field('case_study_image', $relatedCaseStudy->ID); ?>">
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<?php
while (have_posts()) {
    the_post();
    if(have_rows('sections')){
        while(have_rows('sections')) {
            the_row();
            get_template_part('templates/sections/' . get_row_layout());
        }
    }
}
?>
