<?php
$numberOfVideos = get_sub_field('number_of_videos_to_display');
//get our video information
$videoOneType = get_sub_field('video_1_type');
$videoOneExternal = get_sub_field('video_1_external');
$videoOneInternal = get_sub_field('video_1_internal');
$videoTwoType = get_sub_field('video_2_type');
$videoTwoExternal = get_sub_field('video_2_external');
$videoTwoInternal = get_sub_field('video_2_internal');
$videoThreeType = get_sub_field('video_3_type');
$videoThreeExternal = get_sub_field('video_3_external');
$videoThreeInternal = get_sub_field('video_3_internal');

$title = get_sub_field('title');
$subtitle = get_sub_field('subtitle');
$description = get_sub_field('description');
$disableSVGs = get_sub_field('disable_svgs');

switch ($numberOfVideos) {
    case "1":
        $class = '1-video';
        break;
    case "2":
        $class = '2-videos';
        break;
    case "3":
        $class = '3-videos';
        break;
}
?>

<section class="section section--video-panel <?= $class; ?> <?php the_sub_field('background_colour'); ?>">


    <?php
    if(!$disableSVGs) {
        \Blue2\Scruffy\Site::inlineSVG('/dist/images/hexagons/hex-4.svg', 'hex-4', '', false);
        \Blue2\Scruffy\Site::inlineSVG('/dist/images/hexagons/hex-5.svg', 'hex-5', '', false);
        \Blue2\Scruffy\Site::inlineSVG('/dist/images/hexagons/hex-6.svg', 'hex-6', '', false);
    }
    ?>

    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4 title">
                    <h2><?= $title; ?> </h2>
                </div>
                <div class="col-lg-8 description">
                    <?= $description; ?>
                </div>
            </div>
        </div>
    </div>


    <?php if($numberOfVideos == 1) {
        //only one video needed
        ?>
        <div class="container-fluid">
            <div class="video-grid">
                <div class="video1">
                    <div class="video-wrapper">
                        <?php if($videoOneType == 'media') {?>
                            <video controls>
                                <source src="<?= $videoOneInternal; ?>" type="video/mp4">
                            </video>
                        <?php } elseif($videoOneType == 'external') {
                            echo $videoOneExternal;
                        } ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } else if($numberOfVideos == 2) {
        //2 videos use bootstrap 2 columns
        ?>
        <div class="container-fluid">
            <div class="video-grid two-items">
                <div class="video1">
                    <div class="video-wrapper">
                        <?php if($videoOneType == 'media') {?>
                            <video controls>
                                <source src="<?= $videoOneInternal; ?>" type="video/mp4">
                            </video>
                        <?php } elseif($videoOneType == 'external') {
                            echo $videoOneExternal;
                        } ?>
                    </div>
                </div>
                <div class="video2">
                    <div class="video-wrapper">
                        <?php if($videoTwoType == 'media') {?>
                            <video controls>
                                <source src="<?= $videoTwoInternal; ?>" type="video/mp4">
                            </video>
                        <?php } elseif($videoTwoType == 'external') {
                            echo $videoTwoExternal;
                        } ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } else if($numberOfVideos == 3) {
        //3 videos needed, use a bootstrap 2 column, with 2 videos on the right?>
        <div class="container-fluid p-0">
            <div class="video-grid three-items">
                <div class="video1">
                    <div class="video-wrapper">
                        <?php if($videoOneType == 'media') {?>
                            <video controls>
                                <source src="<?= $videoOneInternal; ?>" type="video/mp4">
                            </video>
                        <?php } elseif($videoOneType == 'external') {
                            echo $videoOneExternal;
                        } ?>
                    </div>
                </div>
                <div class="video2">
                    <div class="video-wrapper">
                        <?php if($videoTwoType == 'media') {?>
                            <video controls>
                                <source src="<?= $videoTwoInternal; ?>" type="video/mp4">
                            </video>
                        <?php } elseif($videoTwoType == 'external') {
                            echo $videoTwoExternal;
                        } ?>
                    </div>
                </div>
                <div class="video3">
                    <div class="video-wrapper">
                        <?php if($videoThreeType == 'media') {?>
                            <video controls>
                                <source src="<?= $videoThreeInternal; ?>" type="video/mp4">
                            </video>
                        <?php } elseif($videoThreeType == 'external') {
                            echo $videoThreeExternal;
                        } ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    <?php if($subtitle) { ?>
        <div class="sub-text container-fluid">
            <p><?= $subtitle; ?></p>
        </div>
    <?php } ?>
</section>
