<?php
$title = is_archive('product') ? get_field('product_title', 'option') : get_sub_field('title');
$subtitle = is_archive('product') ? get_field('product_subtitle', 'option') : get_sub_field('subtitle');
$caption = is_archive('product') ? get_field('product_intro', 'option') : get_sub_field('caption');
?>


<div class="swiper-slide">
    <?php if($title) { ?>
        <h3><?= $title; ?></h3>
    <?php } ?>

    <?php if($subtitle) { ?>
        <h1><?= $subtitle; ?></h1>
    <?php } ?>

    <?php if($caption) { ?>
        <div class="caption"><?= $caption; ?></div>
    <?php } ?>

    <?php if(have_rows('call_to_action')) { ?>
        <div class="cta-wrapper">
            <?php
            while(have_rows('call_to_action')) {
                the_row();
                $targetBlank = get_sub_field('open_new_tab') ? 'target="_blank"' : '';
                ?>
                <a href="<?php the_sub_field('url'); ?>" class="cta cta--url" <?= $targetBlank; ?>>
                    <i class="fal fa-long-arrow-right"></i><?php the_sub_field('label'); ?>
                </a>
            <?php } ?>
        </div>
    <?php } ?>
</div>
