<?php 
get_header(); 
$term = get_queried_object();
$title = get_field('title', $term) ?: single_cat_title('', false);
$darkMode = get_field('enable_dark_mode', $term);
?>

    <div class="section section--product-archive <?php if($darkMode) { echo 'dark'; } ?>">
        <div class="product-archive">
            <?php
            if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
            }
            ?>
            <div class="product-header">
                <?php if(get_field('subtitle', $term)) { ?>
                    <h3><?php the_field('subtitle', $term); ?></h3>
                <?php } ?>

                <h1><?= $title; ?></h1>

                <?php if(category_description()) { ?>
                    <p class="caption"><?= category_description(); ?></p>
                <?php } ?>
            </div>

            <div class="product-wrapper">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
            </div>
        </div>
        <div id="particles-js"></div>
    </div>

<?php get_footer(); ?>