<?php
$products = get_sub_field('products');

if($products) {
    ?>
    <section class="section section--news-panel <?php the_sub_field('background_colour'); ?>">
        <div class="container">
            <div class="row">
                <?php foreach( $products as $product ) {
                    $post = $product['product'];
                    setup_postdata($post);

                    if($product['product_image']) {
                        $image = $product['product_image'];
                    } else {
                        $image = get_the_post_thumbnail_url();
                    }

                    if($product['cta_button'] !== '') {
                        //override the link text
                        $ctaText = $product['cta_button'];
                    } else {
                        $ctaText = get_the_title();
                    }
                    ?>
                    <div class="col">
                        <div class="row">
                            <div class="col-12">
                                <img class="img-responsive" src="<?= $image; ?>" />
                            </div>
                            <div class="col-12">
                                <h2><?= get_the_title(); ?></h2>
                                <?= get_the_excerpt(); ?>

                                <div class="cta-wrapper ">
                                    <a href="<?= get_permalink(); ?>" class="cta--btn btn">
                                        <span><?= $ctaText; ?></span>            
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } 
                wp_reset_postdata()
                ?>
            </div>
        </div>
    </section>
<?php }