<?php
$backgroundColour = get_sub_field('background_colour');
?>

<div class="fifty-fifty-panel-with-images <?= $backgroundColour; ?>">
    <div class="wrapper wrapper-left">
        <?php
        if(have_rows('content_wrapper_left')) {
            while(have_rows('content_wrapper_left')) {
                the_row(); ?>

                <div class="content-wrapper">
                    <div class="inner">
                        <?php the_sub_field('content'); ?>
                        <?php include(locate_template('templates/parts/part-cta.php')); ?>
                    </div>
                </div>

                <?php $image = get_sub_field('image') ? wp_get_attachment_image_src(get_sub_field('image'), 'large') : '';
                if($image) {
                    $alt = get_post_meta($image[0], '_wp_attachment_image_alt', TRUE) ?: ''; ?>
                    <img class="left-image img-responsive" src="<?= $image[0]; ?>" alt="<?=$alt;?>"/>
                    <?php
                }
            }
        }
        ?>
    </div>
    <div class="wrapper wrapper-right">
        <?php
        if(have_rows('content_wrapper_right')) {
            while(have_rows('content_wrapper_right')) {
                the_row(); ?>
                <div class="content-wrapper">
                    <div class="inner">
                        <?php the_sub_field('content'); ?>
                        <?php include(locate_template('templates/parts/part-cta.php')); ?>
                    </div>
                </div>
                <?php $image = get_sub_field('image') ? wp_get_attachment_image_src(get_sub_field('image'), 'large') : '';
                if($image) {
                    $alt = get_post_meta($image[0], '_wp_attachment_image_alt', TRUE) ?: '';
                    ?>
                    <img class="right-image img-responsive" src="<?= $image[0]; ?>" alt="<?=$alt;?>"/>
                    <?php
                }
            }
        }
        ?>
    </div>
</div>
