<?php session_start(); ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-M7WXZM6');</script>
    <!-- End Google Tag Manager -->
    
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php
    /**
     * Fonts loaded from Typekit but deferred with high priority
     *
     * @see https://csswizardry.com/2020/05/the-fastest-google-fonts/
     */
    $font_url = 'https://use.typekit.net/akv5uef.css';
    ?>
    <link rel="preconnect" href="https://use.typekit.net" crossorigin>
    <link rel="preconnect" href="https://p.typekit.net" crossorigin>
    <link rel="preload" as="style" href="<?= $font_url; ?>">
    <link rel="stylesheet" href="<?= $font_url; ?>" media="print" onload="this.media='all'" />
    <noscript><link rel="stylesheet" href="<?= $font_url ?>" /></noscript>
    <!-- Start of Zendesk Widget script -->
    <script id="ze-snippet" src="https://static.zdassets.com/ekr/snippet.js?key=web_widget/crossbowsoptical.zendesk.com"></script>
    <!-- End of Zendesk Widget script -->
    <?php wp_head(); ?>
</head>

<?php $language = defined('ICL_LANGUAGE_CODE') ? ICL_LANGUAGE_CODE : 'en'; ?>

<body <?php body_class(); ?> data-language-code="<?= $language; ?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-M7WXZM6"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
