<?php
namespace Blue2\Scruffy;

class Utils extends \Blue2\Common\Theme\Utils
{
    public static function postArchiveFlexibleLoop($fieldName = "sections")
    {
        Utils::archiveFlexibleLoop($fieldName, 'post_archive_settings');
    }

    public static function customPostArchiveFlexibleLoop($fieldName = "sections")
    {
        $object = get_queried_object();
        $optionsId = $object->name . '_settings';
        Utils::archiveFlexibleLoop($fieldName, $optionsId);
    }

    private static function archiveFlexibleLoop($fieldName, $optionsId)
    {
        if (have_rows($fieldName, $optionsId)) {
            while (have_rows($fieldName, $optionsId)) {
                the_row();
                get_template_part('templates/sections/' . get_row_layout());
            }
        }
    }

    public static function postArchiveLoop()
    {
        $args = [
            'posts_per_page' => 1,
            'post_type' => 'post',
            'post_status' => 'publish',
        ];
        $featuredPost = new \WP_Query( $args );

        include(locate_template('templates/post/content-featured.php'));

        if (have_posts()) {
            $darkMode = get_field('enable_dark_mode', 'option');
            $extraClass = '';

            if($darkMode) {
                $extraClass = 'dark';
            }

            echo "<div class='section section--post-archive " . $extraClass . "'>";
            while (have_posts()) {
                the_post();
                if(get_the_ID() !== $featuredPost->posts[0]->ID) {
                    include(locate_template('templates/post/content.php'));
                }
            }
            the_posts_pagination([
                'mid_size'  => 2,
                'screen_reader_text' => ' ',
                'prev_text' => __( 'Previous', 'textdomain' ),
                'next_text' => __( 'Next', 'textdomain' ),
            ]);
            echo "</div>";
        } else {
            get_template_part('templates/content', 'none');
        }
    }
}
