import '@babel/polyfill'; // Required for build
import load from './loader'; // Required for loading files dynamically
import 'bootstrap/js/dist/util'; // All Bootstrap JS requires Util
import 'bootstrap/js/dist/collapse'; // Used for nav collapse functionality
import '@fortawesome/fontawesome-pro/js/brands.min.js';
import '@fortawesome/fontawesome-pro/js/light.min.js';
import '@fortawesome/fontawesome-pro/js/fontawesome.min.js';

import common from './common';
import compare from './compare';
/*
    Basic Event Routing
    -------------------
    Switch on body class that gets applied either due to page, post type or page template
    Replace '-' in the class name with '_'
*/
const route = className => {
    switch (className) {

        case 'single_post':
            load('./post');
            break;
        case 'single_product':
            load('./product.js');
            break;
        case 'post_type_archive_person':
            load('./person/archive.js');
            break;

    }
};

// Fire events once document has loaded
document.addEventListener('DOMContentLoaded', () => {
    common(); // Run common code on every page
    compare(); // Run compare code on every page

    const bodyClasses = document.body.className // Get all body classes,
        .replace(/-/g, '_') // replace dashes with underscores,
        .replace(/page_template_/g, '') // remove prefix 'page_template' from template classes, &
        .split(/\s+/); // split on whitespace

    for (const value of bodyClasses) { // eslint-disable-line no-unused-vars
        route(value);
    }
});
